/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.intermediate;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.intermediate.AdaptIntermediatePortableCursor;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateStructCollectingCursor;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateCursor;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSeance;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateCursor;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSeance;

public class AdaptIntermediateSeance
implements IntegralIntermediateSeance {
    @NotNull
    private final PrimeIntermediateSeance myRemoteSeance;

    public AdaptIntermediateSeance(@NotNull PrimeIntermediateSeance remoteSeance) {
        this.myRemoteSeance = remoteSeance;
    }

    @Override
    public void setInParameters(@NotNull Object[] parameters) {
        this.myRemoteSeance.setInParameters(parameters);
    }

    @Override
    public void setPackLimit(int packLimit) {
        this.myRemoteSeance.setPackLimit(packLimit);
    }

    @Override
    public void execute() {
        this.myRemoteSeance.execute();
    }

    @Override
    public int getAffectedRowsCount() {
        return this.myRemoteSeance.getAffectedRowsCount();
    }

    @Override
    @NotNull
    public <R> IntegralIntermediateCursor<R> openCursor(int parameterPosition, @NotNull ResultLayout<R> layout) {
        if (layout.isPortable()) {
            PrimeIntermediateCursor<R> remoteCursor = this.myRemoteSeance.openCursor(parameterPosition, layout);
            return new AdaptIntermediatePortableCursor<R>(remoteCursor);
        }
        ResultLayout<List<Object[]>> intermediateLayout = layout.makeIntermediateLayout();
        PrimeIntermediateCursor<List<Object[]>> remoteCursor = this.myRemoteSeance.openCursor(parameterPosition, intermediateLayout);
        return new AdaptIntermediateStructCollectingCursor<R>(remoteCursor, layout);
    }

    @Override
    public void close() {
        this.myRemoteSeance.close();
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        return this.myRemoteSeance.getSpecificService(serviceClass, serviceName);
    }
}

