/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryResource
extends Resource {
    private final URL myUrl;
    private final byte[] myContent;
    private final Map<Resource.Attribute, String> myAttributes;

    private MemoryResource(URL url, byte[] content, Map<Resource.Attribute, String> attributes) {
        this.myUrl = url;
        this.myContent = content;
        this.myAttributes = attributes;
    }

    @Override
    public URL getURL() {
        return this.myUrl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.myContent;
    }

    @Override
    public String getValue(Resource.Attribute key) {
        return this.myAttributes != null ? this.myAttributes.get((Object)key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static MemoryResource load(URL baseUrl, @NotNull ZipFile zipFile, @NotNull ZipEntry entry, @Nullable Map<Resource.Attribute, String> attributes) throws IOException {
        if (zipFile == null) {
            MemoryResource.$$$reportNull$$$0(0);
        }
        if (entry == null) {
            MemoryResource.$$$reportNull$$$0(1);
        }
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtil.EMPTY_BYTE_ARRAY;
        InputStream stream = zipFile.getInputStream(entry);
        if (stream != null) {
            try {
                content = FileUtil.loadBytes(stream, (int)entry.getSize());
            }
            finally {
                stream.close();
            }
        }
        MemoryResource memoryResource = new MemoryResource(url, content, attributes);
        if (memoryResource == null) {
            MemoryResource.$$$reportNull$$$0(2);
        }
        return memoryResource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/MemoryResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/MemoryResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

