/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.ServerBaseDeployable;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerDeployableWithTempCredentials
extends ServerBaseDeployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);
    protected Credentials myCredentials;
    protected boolean isPassMemoryOnly;

    public ServerDeployableWithTempCredentials(@NotNull WebServerConfig server) {
        if (server == null) {
            ServerDeployableWithTempCredentials.$$$reportNull$$$0(0);
        }
        super(server);
        this.isPassMemoryOnly = true;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.myCredentials;
    }

    @Override
    public boolean isPassMemoryOnly() {
        return this.isPassMemoryOnly;
    }

    @Override
    public void setCredentials(Credentials credentials, boolean memoryOnly, boolean isApplyCredentialsToPasswordSafe, boolean notifyGlobalUpdate) {
        this.myCredentials = credentials;
        this.isPassMemoryOnly = memoryOnly;
        if (isApplyCredentialsToPasswordSafe) {
            WebDeploymentCredentialHelper.saveCredentials(this.myServer, memoryOnly, credentials);
        }
        if (notifyGlobalUpdate) {
            LOG.assertTrue(isApplyCredentialsToPasswordSafe);
            ApplicationManager.getApplication().invokeLater(() -> ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged());
        }
    }

    @Override
    @NotNull
    public Deployable copyToImmutable() {
        ServerBaseDeployable serverBaseDeployable = this.clone();
        if (serverBaseDeployable == null) {
            ServerDeployableWithTempCredentials.$$$reportNull$$$0(1);
        }
        return serverBaseDeployable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerDeployableWithTempCredentials that = (ServerDeployableWithTempCredentials)o;
        if (!this.myServer.equals(that.myServer)) {
            return false;
        }
        if (this.myCredentials == null ? that.myCredentials != null : !this.myCredentials.equals((Object)that.myCredentials)) {
            return false;
        }
        return this.isPassMemoryOnly == that.isPassMemoryOnly;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + (this.myCredentials == null ? 0 : this.myCredentials.hashCode());
        result = result * 31 + (this.isPassMemoryOnly ? 0 : 1);
        return result;
    }

    @Override
    public String toString() {
        return "ServerBaseDeployable{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + ", passMemoryOnly=" + this.isPassMemoryOnly + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/ServerDeployableWithTempCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/ServerDeployableWithTempCredentials";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToImmutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

