/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GroupedServersConfigManager {
    @NotNull
    public static GroupedServersConfigManager getInstance(@Nullable Project project) {
        GroupedServersConfigManager groupedServersConfigManager = (GroupedServersConfigManager)ServiceManager.getService((Project)(project == null ? ProjectManager.getInstance().getDefaultProject() : project), GroupedServersConfigManager.class);
        if (groupedServersConfigManager == null) {
            GroupedServersConfigManager.$$$reportNull$$$0(0);
        }
        return groupedServersConfigManager;
    }

    @NotNull
    public List<WebServerGroupingWrap> getGroupedServers();

    @Deprecated
    @NotNull
    public List<WebServerConfig> getFlattenedServers(boolean var1);

    @NotNull
    public List<WebServerConfig> getFlattenedServers();

    public void setGroupedServers(@NotNull List<WebServerGroupingWrap> var1);

    public void addServer(WebServerConfig var1);

    public boolean removeServer(@Nullable String var1);

    public WebServerConfig moveServer(WebServerConfig var1);

    public boolean hasServers(boolean var1);

    public SftpAdvancedOptions getSftpAdvancedOptions();

    public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions var1);

    @Nullable
    default public WebServerConfig findServer(@Nullable String serverId) {
        return this.findServer(serverId, false);
    }

    @Nullable
    default public WebServerConfig findServer(@Nullable String serverId, boolean remoteOnly) {
        if (StringUtil.isEmpty((String)serverId)) {
            return null;
        }
        for (WebServerConfig server : this.getFlattenedServers()) {
            if (remoteOnly && !server.needsTransfer() || !serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    @Nullable
    default public Pair<WebServerGroupingWrap, WebServerConfig> findByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        for (WebServerGroupingWrap wrap : this.getGroupedServers()) {
            if (wrap.isSingleServer()) {
                if (!name.equals(wrap.getName())) continue;
                return Pair.create(null, (Object)wrap.getAsSingleServer());
            }
            if (name.equals(wrap.getName())) {
                return Pair.create((Object)wrap, null);
            }
            for (WebServerConfig server : wrap.getServers()) {
                if (!name.equals(server.getName())) continue;
                return Pair.create((Object)wrap, (Object)server);
            }
        }
        return null;
    }

    default public boolean setUniqueName(@NotNull WebServerConfig config) {
        if (config == null) {
            GroupedServersConfigManager.$$$reportNull$$$0(1);
        }
        HashSet serverNames = new HashSet();
        for (WebServerGroupingWrap wrap : this.getGroupedServers()) {
            serverNames.add(wrap.getName());
            if (wrap.isSingleServer()) continue;
            for (WebServerConfig server : wrap.getServers()) {
                serverNames.add(StringUtil.notNullize((String)server.getName()));
            }
        }
        boolean changed = false;
        String name = StringUtil.notNullize((String)config.getName());
        if (serverNames.contains(name)) {
            int i = 1;
            String serverName = name;
            while (serverNames.contains(serverName)) {
                serverName = name + " (" + i + ")";
                ++i;
            }
            changed = true;
            config.setName(serverName);
        }
        return changed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/GroupedServersConfigManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/GroupedServersConfigManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

