/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgBranchReferenceValidator;

public class HgBookmarkDialog
extends DialogWrapper {
    @NotNull
    private final HgRepository myRepository;
    @NotNull
    private JBTextField myBookmarkName;
    @NotNull
    private JBCheckBox myActiveCheckbox;

    public HgBookmarkDialog(@NotNull HgRepository repository) {
        if (repository == null) {
            HgBookmarkDialog.$$$reportNull$$$0(0);
        }
        super(repository.getProject(), false);
        this.myRepository = repository;
        this.setTitle("Create Bookmark");
        this.setResizable(false);
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.mercurial.create.bookmark";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myBookmarkName;
        if (jBTextField == null) {
            HgBookmarkDialog.$$$reportNull$$$0(1);
        }
        return jBTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = HgBookmarkDialog.class.getName();
        if (string == null) {
            HgBookmarkDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultAnchor(21).setDefaultFill(2);
        JLabel icon = new JLabel(UIUtil.getQuestionIcon(), 2);
        this.myBookmarkName = new JBTextField(13);
        this.myBookmarkName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                HgBookmarkDialog.this.validateFields();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/ui/HgBookmarkDialog$1", "textChanged"));
            }
        });
        JBLabel bookmarkLabel = new JBLabel("Bookmark name:");
        bookmarkLabel.setLabelFor((Component)this.myBookmarkName);
        this.myActiveCheckbox = new JBCheckBox("Inactive", false);
        contentPanel.add((Component)icon, g.nextLine().next().coverColumn(3).pady(10));
        contentPanel.add((Component)bookmarkLabel, g.next().fillCellNone().insets(new Insets(0, 6, 4, 10)));
        contentPanel.add((Component)this.myBookmarkName, g.next().coverLine().setDefaultWeightX(1.0));
        contentPanel.add((Component)this.myActiveCheckbox, g.nextLine().next().next().coverLine(2));
        JPanel jPanel = contentPanel;
        if (jPanel == null) {
            HgBookmarkDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void validateFields() {
        HgBranchReferenceValidator validator = new HgBranchReferenceValidator(this.myRepository);
        String name = this.getName();
        if (!validator.checkInput(name)) {
            String message = validator.getErrorText(name);
            this.setErrorText(message == null ? "You have to specify bookmark name." : message, (JComponent)this.myBookmarkName);
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public boolean isActive() {
        return !this.myActiveCheckbox.isSelected();
    }

    @Nullable
    public String getName() {
        return this.myBookmarkName.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/ui/HgBookmarkDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/ui/HgBookmarkDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

