/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddFileStructure
extends AbstractTestFileStructure {
    private final List<MochaTddSuite> myChildren;
    private final Map<PsiElement, AbstractMochaTddElement> myLeafElementToInfoMap;

    public MochaTddFileStructure(@NotNull JSFile jsFile, @NotNull List<AbstractMochaTddElement> children) {
        if (jsFile == null) {
            MochaTddFileStructure.$$$reportNull$$$0(0);
        }
        if (children == null) {
            MochaTddFileStructure.$$$reportNull$$$0(1);
        }
        super(jsFile);
        this.myLeafElementToInfoMap = ContainerUtil.newIdentityHashMap();
        this.myChildren = MochaTddFileStructure.filterSuites(children);
        for (MochaTddSuite child : this.myChildren) {
            this.registerRecursively(child);
        }
    }

    @NotNull
    private static List<MochaTddSuite> filterSuites(@NotNull List<AbstractMochaTddElement> children) {
        if (children == null) {
            MochaTddFileStructure.$$$reportNull$$$0(2);
        }
        if (children.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                MochaTddFileStructure.$$$reportNull$$$0(3);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(children, MochaTddSuite.class));
        if (immutableList == null) {
            MochaTddFileStructure.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Override
    public boolean isEmpty() {
        if (!this.myChildren.isEmpty()) {
            for (MochaTddSuite child : this.myChildren) {
                if (child.getChildren().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            MochaTddFileStructure.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull String suiteName, @Nullable String testName) {
        if (suiteName == null) {
            MochaTddFileStructure.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        if (this.myChildren.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MochaTddFileStructure.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList out = ContainerUtil.newArrayListWithCapacity((int)this.myChildren.size());
        for (MochaTddSuite suite : this.myChildren) {
            out.add(suite.getName());
        }
        ArrayList arrayList = out;
        if (arrayList == null) {
            MochaTddFileStructure.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        if (topLevelElementName == null) {
            MochaTddFileStructure.$$$reportNull$$$0(9);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            MochaTddFileStructure.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            MochaTddFileStructure.$$$reportNull$$$0(11);
        }
        return false;
    }

    @NotNull
    public List<MochaTddSuite> getTopLevelSuites() {
        List<MochaTddSuite> list = this.myChildren;
        if (list == null) {
            MochaTddFileStructure.$$$reportNull$$$0(12);
        }
        return list;
    }

    public boolean hasMochaTypeScriptDeclarations() {
        for (MochaTddSuite child : this.myChildren) {
            if (!(child.getEnclosingPsiElement() instanceof TypeScriptClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            MochaTddFileStructure.$$$reportNull$$$0(13);
        }
        if (suiteNames.isEmpty()) {
            return null;
        }
        String firstSuiteName = suiteNames.get(0);
        MochaTddSuite currentSuite = null;
        for (MochaTddSuite suite : this.myChildren) {
            if (!suite.getName().equals(firstSuiteName)) continue;
            currentSuite = suite;
            break;
        }
        if (currentSuite == null) {
            return null;
        }
        for (int i = 1; i < suiteNames.size(); ++i) {
            if ((currentSuite = currentSuite.findSuiteByName(suiteNames.get(i))) != null) continue;
            return null;
        }
        if (testName != null) {
            MochaTddTest test = currentSuite.findTestByName(testName);
            return test == null ? null : test.getEnclosingPsiElement();
        }
        return currentSuite.getEnclosingPsiElement();
    }

    @Nullable
    public AbstractMochaTddElement findDeepestElementContainingElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            MochaTddFileStructure.$$$reportNull$$$0(14);
        }
        for (MochaTddSuite suite : this.myChildren) {
            AbstractMochaTddElement result = suite.findDeepestElementContainingRange(textRange);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange range) {
        if (range == null) {
            MochaTddFileStructure.$$$reportNull$$$0(15);
        }
        return MochaTddFileStructure.toTestElementPath(this.findDeepestElementContainingElement(range));
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull PsiElement testIdentifierLeafElement) {
        if (testIdentifierLeafElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(16);
        }
        return MochaTddFileStructure.toTestElementPath(this.myLeafElementToInfoMap.get(testIdentifierLeafElement));
    }

    public List<MochaTddSuite> getChildren() {
        return this.myChildren;
    }

    @Nullable
    private static JsTestElementPath toTestElementPath(@Nullable AbstractMochaTddElement element) {
        PsiElement psiElement;
        String testName;
        MochaTddSuite suite;
        if (element == null) {
            return null;
        }
        if (element instanceof MochaTddSuite) {
            suite = (MochaTddSuite)element;
            testName = null;
            psiElement = suite.getEnclosingPsiElement();
        } else {
            MochaTddTest test = (MochaTddTest)element;
            suite = (MochaTddSuite)element.getParent();
            testName = element.getName();
            psiElement = test.getEnclosingPsiElement();
        }
        List suites = ContainerUtil.newSmartList();
        while (suite != null) {
            suites.add(suite.getName());
            suite = (MochaTddSuite)suite.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath(suites, testName, psiElement);
    }

    private void registerRecursively(@NotNull MochaTddSuite suite) {
        if (suite == null) {
            MochaTddFileStructure.$$$reportNull$$$0(17);
        }
        this.register(suite.getEnclosingPsiElement(), suite);
        for (AbstractMochaTddElement element : suite.getChildren()) {
            if (element instanceof MochaTddSuite) {
                this.registerRecursively((MochaTddSuite)element);
                continue;
            }
            this.register(element.getEnclosingPsiElement(), element);
        }
    }

    private void register(@NotNull PsiElement psiElement, @NotNull AbstractMochaTddElement element) {
        PsiElement identifierElement;
        if (psiElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(18);
        }
        if (element == null) {
            MochaTddFileStructure.$$$reportNull$$$0(19);
        }
        if (psiElement instanceof JSCallExpression) {
            JSCallExpression callExpression = (JSCallExpression)psiElement;
            PsiElement identifierLeafElement = JsPsiUtils.getMethodNameLeafElement(callExpression);
            if (identifierLeafElement != null) {
                this.myLeafElementToInfoMap.put(identifierLeafElement, element);
            }
        } else if (psiElement instanceof TypeScriptClass) {
            PsiElement identifierElement2 = ((TypeScriptClass)psiElement).getNameIdentifier();
            if (identifierElement2 != null) {
                this.myLeafElementToInfoMap.put(MochaTddFileStructure.toLeafElement(identifierElement2), element);
            }
        } else if (psiElement instanceof TypeScriptFunction && (identifierElement = ((TypeScriptFunction)psiElement).getNameIdentifier()) != null) {
            this.myLeafElementToInfoMap.put(MochaTddFileStructure.toLeafElement(identifierElement), element);
        }
    }

    @NotNull
    private static PsiElement toLeafElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(20);
        }
        if (psiElement instanceof JSReferenceExpression) {
            for (PsiElement child : psiElement.getChildren()) {
                if (!child.getTextRange().equals((Object)psiElement.getTextRange())) continue;
                PsiElement psiElement2 = child;
                if (psiElement2 == null) {
                    MochaTddFileStructure.$$$reportNull$$$0(21);
                }
                return psiElement2;
            }
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            MochaTddFileStructure.$$$reportNull$$$0(22);
        }
        return psiElement3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElementName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifierLeafElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuites";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOf";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSuites";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toLeafElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterSuites";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findJstdRunElement";
                break;
            }
            case 6: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestElementContainingElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerRecursively";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toLeafElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

