/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.DataNodeSerializer;
import com.intellij.openapi.externalSystem.model.MultiLoaderObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class JDKSerializer<T>
implements DataNodeSerializer<T> {
    private static final DataNodeSerializer ourInstance = new JDKSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(T data) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (ObjectOutputStream oOut = new ObjectOutputStream(bOut);){
            oOut.writeObject(data);
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
    }

    @Override
    public T readData(byte[] data, ClassLoader ... classLoaders) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try (MultiLoaderObjectInputStream oIn = new MultiLoaderObjectInputStream(inputStream, classLoaders);){
            Object object = oIn.readObject();
            assert (object != null);
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> DataNodeSerializer<T> getInstance() {
        return ourInstance;
    }
}

