/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerConfigurablesUtil;
import com.intellij.docker.DockerPathMappingEditor;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineConfigurable;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudConfigurableBase;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudConfigurable
extends CloudConfigurableBase<DockerCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerCloudConfigurable.class);
    private static final String UNIX_PROTOCOL_PREFIX = "unix://";
    private JTextField myEmailTextField;
    private JPasswordField myPasswordField;
    private JPanel myMainPanel;
    private JTextField myApiUrlTextField;
    private TextFieldWithBrowseButton myCertificatesPathTextField;
    private ComboBox<MachineItem> myMachineComboBox;
    private JPanel myMappingPanel;
    private JPanel myPathMappingPlaceHolder;
    private JBRadioButton myUseFileSocketRadioButton;
    private JRadioButton myUseTCPSocketRadioButton;
    private JBRadioButton myUseDockerMachine;
    private JPanel myTCPPanel;
    private SwingActionLink myDockerMachineErrorLinkLabel;
    private final CollectionComboBoxModel<MachineItem> myMachineComboBoxModel;
    private final DockerPathMappingEditor myPathMappingEditor;
    private volatile boolean myMachineSettingsLoaded;
    private boolean mySkipLoadMachineSettings;
    private String myLatestDockerMachineExecutable;
    private final MachineItemColoredListCellRenderer myMachineCellRenderer;

    public DockerCloudConfigurable(DockerCloudConfiguration configuration) {
        super((ServerType)DockerCloudType.getInstance(), (CloudConfigurationBase)configuration);
        this.$$$setupUI$$$();
        this.myCertificatesPathTextField.addBrowseFolderListener(DockerBundle.getText("DockerCloudConfigurable.chooser.certificates.title", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myMainPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && DockerCloudConfigurable.this.myUseDockerMachine.isSelected()) {
                    DockerCloudConfigurable.this.loadMachines();
                }
            }
        });
        this.myMachineComboBoxModel = new CollectionComboBoxModel();
        this.myMachineComboBox.setModel(this.myMachineComboBoxModel);
        this.myMachineComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCloudConfigurable.this.loadMachineSettings();
            }
        });
        this.myMachineCellRenderer = new MachineItemColoredListCellRenderer();
        this.myMachineComboBox.setRenderer((ListCellRenderer)((Object)this.myMachineCellRenderer));
        this.myDockerMachineErrorLinkLabel.setVisible(false);
        this.myUseFileSocketRadioButton.addActionListener(e -> this.updateConnectionComponentsAvailability());
        this.myUseDockerMachine.addActionListener(e -> this.updateConnectionComponentsAvailability());
        this.myUseTCPSocketRadioButton.addActionListener(e -> this.updateConnectionComponentsAvailability());
        if (SystemInfo.isMac) {
            this.myUseFileSocketRadioButton.setSelected(true);
            this.myUseFileSocketRadioButton.setText("Docker for Mac");
        } else if (SystemInfo.isUnix) {
            this.myUseFileSocketRadioButton.setSelected(true);
        } else {
            this.myUseFileSocketRadioButton.setVisible(false);
            this.myUseTCPSocketRadioButton.setSelected(true);
        }
        this.myMappingPanel.setVisible(!SystemInfo.isLinux);
        this.myPathMappingEditor = new DockerPathMappingEditor();
        this.myPathMappingPlaceHolder.add(this.myPathMappingEditor.getPanel());
    }

    private void selectDockerMachineConfigurable() {
        Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
        if (settings != null) {
            settings.select(DockerCloudConfigurable.findDockerMachineConfigurable(settings));
        }
    }

    @Nullable
    private DockerMachineConfigurable findDockerMachineConfigurable() {
        Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
        return settings != null ? (DockerMachineConfigurable)DockerCloudConfigurable.findDockerMachineConfigurable(settings) : null;
    }

    @Nullable
    private static Configurable findDockerMachineConfigurable(@NotNull Settings settings) {
        if (settings == null) {
            DockerCloudConfigurable.$$$reportNull$$$0(0);
        }
        return settings.find("reference.settingsDialog.application.dockerMachine");
    }

    @NotNull
    private String getRelevantDockerMachineExecutable() {
        DockerMachineConfigurable dockerMachineConfigurable = this.findDockerMachineConfigurable();
        if (dockerMachineConfigurable != null && StringUtil.isNotEmpty((String)dockerMachineConfigurable.getDockerMachineExecutable())) {
            String string = dockerMachineConfigurable.getDockerMachineExecutable();
            if (string == null) {
                DockerCloudConfigurable.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = DockerSettings.getInstance().getDockerMachinePath();
        if (string == null) {
            DockerCloudConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void updateConnectionComponentsAvailability() {
        if (!this.mySkipLoadMachineSettings) {
            this.myMachineComboBox.setEnabled(this.myUseDockerMachine.isSelected());
            if (this.myUseDockerMachine.isSelected()) {
                this.loadMachines();
            }
            UIUtil.setEnabled((Component)this.myTCPPanel, (boolean)this.myUseTCPSocketRadioButton.isSelected(), (boolean)true);
        }
    }

    private void clearMachines() {
        this.resetDockerMachineSettings();
        this.myMachineComboBoxModel.removeAll();
        this.myMachineComboBox.setEnabled(false);
        MachineItem selected = (MachineItem)this.myMachineComboBoxModel.getSelected();
        if (selected != null) {
            MachineItem stored = selected.toStored();
            this.myMachineComboBoxModel.add((Object)stored);
            this.mySkipLoadMachineSettings = true;
            try {
                this.myMachineComboBox.setSelectedItem((Object)stored);
            }
            finally {
                this.mySkipLoadMachineSettings = false;
            }
        }
    }

    private void loadMachines() {
        String executable = this.getRelevantDockerMachineExecutable();
        if (StringUtil.equals((CharSequence)this.myLatestDockerMachineExecutable, (CharSequence)executable)) {
            return;
        }
        this.myLatestDockerMachineExecutable = executable;
        this.clearMachines();
        this.resetDockerMachineSettings();
        MachineItem selected = (MachineItem)this.myMachineComboBoxModel.getSelected();
        this.myMachineComboBoxModel.removeAll();
        this.myMachineComboBoxModel.add((Object)selected);
        final DockerMachine machine = DockerMachine.getDockerMachine(executable);
        this.setDockerMachineErrorNotificationsVisible(false);
        final ModalityState modalityState = ModalityState.current();
        new TaskWithResult<List<MachineItem>>("Loading machines"){

            @Override
            protected List<MachineItem> doPerform() {
                try {
                    return machine.ls().stream().map(name -> new MachineItem((String)name, machine.statusFor((String)name))).filter(MachineItem::hasKnownState).collect(Collectors.toList());
                }
                catch (DockerMachineException e) {
                    if (ExceptionUtil.causedBy((Throwable)e, ProcessNotCreatedException.class)) {
                        ApplicationManager.getApplication().invokeLater(() -> DockerCloudConfigurable.this.setDockerMachineErrorNotificationsVisible(true), modalityState);
                    }
                    throw e;
                }
            }

            @Override
            protected void processResult(List<MachineItem> items) {
                DockerCloudConfigurable.this.myMachineComboBox.setEnabled(true);
                DockerCloudConfigurable.this.myMachineComboBoxModel.removeAll();
                DockerCloudConfigurable.this.myMachineComboBoxModel.add(items);
                DockerCloudConfigurable.this.setDockerMachineErrorNotificationsVisible(false);
                DockerCloudConfigurable.this.updateSelectedMachineItem();
                DockerCloudConfigurable.this.loadMachineSettings();
            }
        }.queue();
    }

    private void setDockerMachineErrorNotificationsVisible(boolean visible) {
        this.myDockerMachineErrorLinkLabel.setVisible(visible);
        this.myMachineCellRenderer.setError(visible);
        this.myMachineComboBox.repaint();
    }

    private void loadMachineSettings() {
        if (!this.mySkipLoadMachineSettings) {
            this.resetDockerMachineSettings();
            if (!this.myUseDockerMachine.isSelected()) {
                return;
            }
            MachineItem item = (MachineItem)this.myMachineComboBoxModel.getSelected();
            if (item != null) {
                item.loadSettings();
            }
        }
    }

    private void resetDockerMachineSettings() {
        this.myMachineSettingsLoaded = false;
        ((DockerCloudConfiguration)this.myConfiguration).setApiUrl(null);
        ((DockerCloudConfiguration)this.myConfiguration).setCertificatesPath(null);
    }

    private void updateDockerMachineSettings(@NotNull DockerConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            DockerCloudConfigurable.$$$reportNull$$$0(3);
        }
        ((DockerCloudConfiguration)this.myConfiguration).setApiUrl(connectionInfo.getApiUrl());
        ((DockerCloudConfiguration)this.myConfiguration).setCertificatesPath(connectionInfo.getCertificatesPath());
        this.myMachineSettingsLoaded = true;
    }

    protected JComponent getMainPanel() {
        return this.myMainPanel;
    }

    protected JTextField getEmailTextField() {
        return this.myEmailTextField;
    }

    protected JPasswordField getPasswordField() {
        return this.myPasswordField;
    }

    public boolean isModified() {
        if (this.myUseDockerMachine.isSelected()) {
            MachineItem selectedMachineItem = (MachineItem)this.myMachineComboBoxModel.getSelected();
            String selectedMachine = selectedMachineItem != null ? selectedMachineItem.getName() : null;
            return !StringUtil.equals((CharSequence)selectedMachine, (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getMachine()) || !ContainerUtil.equalsIdentity(this.myPathMappingEditor.getItems(), ((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
        }
        if (this.myUseFileSocketRadioButton.isSelected()) {
            return !StringUtil.equals((CharSequence)DockerCloudConfigurable.getDefaultUnixSocketApiUrl(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getApiUrl()) || !StringUtil.isEmpty((String)((DockerCloudConfiguration)this.myConfiguration).getMachine()) || !ContainerUtil.equalsIdentity(this.myPathMappingEditor.getItems(), ((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
        }
        return !StringUtil.equals((CharSequence)this.myApiUrlTextField.getText(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getApiUrl()) || !StringUtil.equals((CharSequence)this.myCertificatesPathTextField.getText(), (CharSequence)((DockerCloudConfiguration)this.myConfiguration).getCertificatesPath()) || !StringUtil.isEmpty((String)((DockerCloudConfiguration)this.myConfiguration).getMachine()) || !ContainerUtil.equalsIdentity(this.myPathMappingEditor.getItems(), ((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
    }

    public boolean canCheckConnection() {
        if (this.myUseDockerMachine.isSelected()) {
            return this.myMachineSettingsLoaded;
        }
        return true;
    }

    private void createUIComponents() {
        this.myDockerMachineErrorLinkLabel = new SwingActionLink((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCloudConfigurable.this.selectDockerMachineConfigurable();
            }
        });
    }

    @Contract(pure=true)
    @NotNull
    private static String getDefaultUnixSocketApiUrl() {
        if ("unix:///var/run/docker.sock" == null) {
            DockerCloudConfigurable.$$$reportNull$$$0(4);
        }
        return "unix:///var/run/docker.sock";
    }

    public void reset() {
        if (((DockerCloudConfiguration)this.myConfiguration).getMachine() != null) {
            MachineItem stored = new MachineItem(((DockerCloudConfiguration)this.myConfiguration).getMachine(), null);
            this.myMachineComboBoxModel.add((Object)stored);
            this.mySkipLoadMachineSettings = true;
            try {
                this.myMachineComboBox.setSelectedItem((Object)stored);
            }
            finally {
                this.mySkipLoadMachineSettings = false;
            }
            this.myUseDockerMachine.setSelected(true);
            this.updateSelectedMachineItem();
        } else if (DockerCloudConfigurable.isUnixDomainSocketCanBeUsed() && DockerCloudConfigurable.isUnixDomainSocketApiUrl(((DockerCloudConfiguration)this.myConfiguration).getApiUrl())) {
            this.myUseFileSocketRadioButton.setSelected(true);
        } else {
            this.myApiUrlTextField.setText(((DockerCloudConfiguration)this.myConfiguration).getApiUrl());
            this.myCertificatesPathTextField.setText(((DockerCloudConfiguration)this.myConfiguration).getCertificatesPath());
            this.myUseTCPSocketRadioButton.setSelected(true);
        }
        this.myPathMappingEditor.setItems(((DockerCloudConfiguration)this.myConfiguration).getPathMappings());
        this.updateConnectionComponentsAvailability();
    }

    @Contract(pure=true)
    private static boolean isUnixDomainSocketApiUrl(@Nullable String apiUrl) {
        return apiUrl != null && apiUrl.startsWith(UNIX_PROTOCOL_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectedMachineItem() {
        if (this.myMachineComboBoxModel.isEmpty()) {
            return;
        }
        MachineItem selectedItem = (MachineItem)this.myMachineComboBoxModel.getSelected();
        for (MachineItem item : this.myMachineComboBoxModel.getItems()) {
            if (selectedItem != null && !StringUtil.equals((CharSequence)selectedItem.getName(), (CharSequence)item.getName())) continue;
            selectedItem = item;
        }
        this.mySkipLoadMachineSettings = true;
        try {
            this.myMachineComboBoxModel.setSelectedItem((Object)selectedItem);
        }
        finally {
            this.mySkipLoadMachineSettings = false;
        }
    }

    protected void applyCoreTo(DockerCloudConfiguration configuration, boolean forComparison) throws ConfigurationException {
        if (this.myUseFileSocketRadioButton.isSelected()) {
            configuration.setApiUrl(DockerCloudConfigurable.getDefaultUnixSocketApiUrl());
            configuration.setCertificatesPath(null);
            configuration.setMachine(null);
        } else if (this.myUseDockerMachine.isSelected()) {
            MachineItem machineItem;
            String machine = null;
            if (this.myUseDockerMachine.isSelected() && (machineItem = (MachineItem)this.myMachineComboBoxModel.getSelected()) != null) {
                machine = machineItem.getName();
            }
            configuration.setMachine(machine);
        } else if (this.myUseTCPSocketRadioButton.isSelected()) {
            String apiUrl = this.myApiUrlTextField.getText();
            if (StringUtil.isEmpty((String)apiUrl)) {
                throw new RuntimeConfigurationError(DockerBundle.getText("DockerCloudConfigurable.error.apiUrlRequired", new Object[0]));
            }
            String certificatesPath = this.myCertificatesPathTextField.getText();
            if (!StringUtil.isEmpty((String)certificatesPath) && !new File(certificatesPath).exists()) {
                throw new RuntimeConfigurationError(DockerBundle.getText("DockerCloudConfigurable.error.certificatesFolder.missing", certificatesPath));
            }
            configuration.setApiUrl(apiUrl);
            configuration.setCertificatesPath(certificatesPath);
            configuration.setMachine(null);
        } else {
            throw new RuntimeConfigurationError("No connection specified");
        }
        configuration.setPathMappings(this.myPathMappingEditor.getItems());
    }

    protected boolean isCoreConfigEqual(DockerCloudConfiguration configuration1, DockerCloudConfiguration configuration2) {
        return super.isCoreConfigEqual((CloudConfigurationBase)configuration1, (CloudConfigurationBase)configuration2) && Comparing.equal((String)configuration1.getApiUrl(), (String)configuration2.getApiUrl()) && Comparing.equal((String)configuration1.getCertificatesPath(), (String)configuration2.getCertificatesPath()) && Comparing.haveEqualElements(configuration1.getPathMappings(), configuration2.getPathMappings());
    }

    @Contract(pure=true)
    private static boolean isUnixDomainSocketCanBeUsed() {
        return SystemInfo.isUnix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerCloudConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerCloudConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantDockerMachineExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSocketApiUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDockerMachineConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDockerMachineSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPasswordField jPasswordField;
        JTextField jTextField;
        ComboBox comboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField2;
        JPanel jPanel3;
        JBRadioButton jBRadioButton2;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setName("");
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Email:");
        jBLabel.setVisible(false);
        jPanel4.add((Component)jBLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jBLabel2.setVisible(false);
        jPanel4.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseFileSocketRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Unix socket");
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Connect to Docker daemon with:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myTCPPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(4, 0, 2, 3, 0, 3, 3, 3, null, null, null, 4));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Engine API URL:");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Certificates folder:");
        jPanel3.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApiUrlTextField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, new Dimension(250, -1), new Dimension(150, -1), null));
        this.myCertificatesPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseDockerMachine = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Docker Machine:");
        jPanel4.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myMappingPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPathMappingPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Path mappings:");
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMachineComboBox = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, new Dimension(250, -1), null, null));
        this.myEmailTextField = jTextField = new JTextField();
        ((Component)jTextField).setVisible(false);
        jPanel4.add((Component)jTextField, new GridConstraints(7, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        ((Component)jPasswordField).setVisible(false);
        jPanel4.add((Component)jPasswordField, new GridConstraints(8, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUseTCPSocketRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("TCP socket");
        jPanel4.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        SwingActionLink swingActionLink = this.myDockerMachineErrorLinkLabel;
        swingActionLink.setText("Configure executable");
        jPanel4.add((Component)swingActionLink, new GridConstraints(2, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jPasswordField);
        jBLabel4.setLabelFor(jTextField2);
        jBLabel5.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add(jRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class MachineItemColoredListCellRenderer
    extends ColoredListCellRenderer<MachineItem> {
        private char[] myHint;
        private boolean myError;

        private MachineItemColoredListCellRenderer() {
        }

        private void setHint(String hint) {
            this.myHint = hint == null ? null : hint.toCharArray();
        }

        public void setError(boolean error) {
            this.myError = error;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MachineItem> list, MachineItem value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MachineItemColoredListCellRenderer.$$$reportNull$$$0(0);
            }
            String state = null;
            if (value != null) {
                this.append(value.getName());
                state = value.getState();
            }
            this.setHint(state);
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
            if (this.myHint != null) {
                DockerConfigurablesUtil.paintHint(g, (Component)((Object)this), this.myHint);
            }
            if (this.myError) {
                DockerConfigurablesUtil.paintHintIcon(g, (Component)((Object)this), AllIcons.Ide.FatalError);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/docker/DockerCloudConfigurable$MachineItemColoredListCellRenderer", "customizeCellRenderer"));
        }
    }

    private static abstract class TaskWithResult<T>
    extends Task.Backgroundable {
        TaskWithResult(@NotNull String title) {
            if (title == null) {
                TaskWithResult.$$$reportNull$$$0(0);
            }
            super(null, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                TaskWithResult.$$$reportNull$$$0(1);
            }
            indicator.setIndeterminate(true);
            try {
                T result = this.doPerform();
                UIUtil.invokeLaterIfNeeded(() -> this.processResult(result));
            }
            catch (RuntimeException e) {
                LOG.debug((Throwable)e);
            }
        }

        protected abstract T doPerform();

        protected abstract void processResult(T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerCloudConfigurable$TaskWithResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MachineItem {
        private final String myName;
        private final String myState;

        MachineItem(@Nullable String name, String state) {
            this.myName = name;
            this.myState = state;
        }

        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getState() {
            return this.myState;
        }

        public boolean hasKnownState() {
            return this.myState != null;
        }

        @NotNull
        public MachineItem toStored() {
            MachineItem machineItem = new MachineItem(this.myName, null);
            if (machineItem == null) {
                MachineItem.$$$reportNull$$$0(0);
            }
            return machineItem;
        }

        public String toString() {
            return this.myName + " (" + (this.myState == null ? "Unknown/Error" : this.myState) + ")";
        }

        public void loadSettings() {
            String executable = DockerCloudConfigurable.this.getRelevantDockerMachineExecutable();
            final DockerMachine machine = DockerMachine.getDockerMachine(executable);
            DockerCloudConfigurable.this.resetDockerMachineSettings();
            new TaskWithResult<DockerConnectionInfo>(DockerBundle.getText("DockerCloudConfigurable.task.loading.machines.title", new Object[0])){

                @Override
                protected DockerConnectionInfo doPerform() {
                    return machine.getDockerConnectionInfo(MachineItem.this.myName);
                }

                @Override
                protected void processResult(DockerConnectionInfo connectionInfo) {
                    DockerCloudConfigurable.this.updateDockerMachineSettings(connectionInfo);
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudConfigurable$MachineItem", "toStored"));
        }
    }
}

