/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class RemoteEndpoint
implements Endpoint,
MessageConsumer,
MethodProvider {
    private static final Logger LOG = Logger.getLogger(RemoteEndpoint.class.getName());
    public static final Function<Throwable, ResponseError> DEFAULT_EXCEPTION_HANDLER = throwable -> {
        if (throwable instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable).getResponseError();
        }
        if ((throwable instanceof CompletionException || throwable instanceof InvocationTargetException) && throwable.getCause() instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable.getCause()).getResponseError();
        }
        LOG.log(Level.SEVERE, "Internal error: " + throwable.getMessage(), (Throwable)throwable);
        ResponseError error = new ResponseError();
        error.setMessage("Internal error.");
        error.setCode(ResponseErrorCode.InternalError);
        ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
        PrintWriter stackTraceWriter = new PrintWriter(stackTrace);
        throwable.printStackTrace(stackTraceWriter);
        stackTraceWriter.flush();
        error.setData(stackTrace.toString());
        return error;
    };
    private final MessageConsumer out;
    private final Endpoint localEndpoint;
    private final Function<Throwable, ResponseError> exceptionHandler;
    private final AtomicInteger nextRequestId = new AtomicInteger();
    private final Map<String, PendingRequestInfo> sentRequestMap = new LinkedHashMap<String, PendingRequestInfo>();
    private final Map<String, CompletableFuture<?>> receivedRequestMap = new LinkedHashMap();

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint, Function<Throwable, ResponseError> exceptionHandler) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (localEndpoint == null) {
            throw new NullPointerException("localEndpoint");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler");
        }
        this.out = out;
        this.localEndpoint = localEndpoint;
        this.exceptionHandler = exceptionHandler;
    }

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint) {
        this(out, localEndpoint, DEFAULT_EXCEPTION_HANDLER);
    }

    @Override
    public void notify(String method, Object parameter) {
        NotificationMessage notificationMessage = new NotificationMessage();
        notificationMessage.setJsonrpc("2.0");
        notificationMessage.setMethod(method);
        notificationMessage.setParams(parameter);
        this.out.consume(notificationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> request(String method, Object parameter) {
        RequestMessage requestMessage = new RequestMessage();
        final String id = String.valueOf(this.nextRequestId.incrementAndGet());
        requestMessage.setId(id);
        requestMessage.setMethod(method);
        requestMessage.setParams(parameter);
        CompletableFuture<Object> result = new CompletableFuture<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                RemoteEndpoint.this.sendCancelNotification(id);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        Consumer<ResponseMessage> responseHandler = responseMessage -> {
            if (responseMessage.getError() != null) {
                result.completeExceptionally(new ResponseErrorException(responseMessage.getError()));
            } else {
                result.complete(responseMessage.getResult());
            }
        };
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            this.sentRequestMap.put(id, new PendingRequestInfo(requestMessage, responseHandler));
        }
        this.out.consume(requestMessage);
        return result;
    }

    protected void sendCancelNotification(String id) {
        CancelParams cancelParams = new CancelParams();
        cancelParams.setId(id);
        this.notify(MessageJsonHandler.CANCEL_METHOD.getMethodName(), cancelParams);
    }

    @Override
    public void consume(Message message) {
        if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            this.handleNotification(notificationMessage);
        } else if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            this.handleRequest(requestMessage);
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            this.handleResponse(responseMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse(ResponseMessage responseMessage) {
        PendingRequestInfo pendingRequestInfo;
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            pendingRequestInfo = this.sentRequestMap.remove(responseMessage.getId());
        }
        if (pendingRequestInfo == null) {
            LOG.log(Level.WARNING, "Unmatched response message: " + responseMessage);
        } else {
            try {
                pendingRequestInfo.responseHandler.accept(responseMessage);
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Handling repsonse threw an exception: " + responseMessage, e);
            }
        }
    }

    protected void handleNotification(NotificationMessage notificationMessage) {
        if (!this.handleCancellation(notificationMessage)) {
            try {
                this.localEndpoint.notify(notificationMessage.getMethod(), notificationMessage.getParams());
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Notification threw an exception: " + notificationMessage, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCancellation(NotificationMessage notificationMessage) {
        if (MessageJsonHandler.CANCEL_METHOD.getMethodName().equals(notificationMessage.getMethod())) {
            Object cancelParams = notificationMessage.getParams();
            if (cancelParams != null) {
                if (cancelParams instanceof CancelParams) {
                    Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
                    synchronized (map) {
                        String id = ((CancelParams)cancelParams).getId();
                        CompletableFuture<?> future = this.receivedRequestMap.get(id);
                        if (future != null) {
                            future.cancel(true);
                        } else {
                            LOG.warning("Unmatched cancel notification for request id " + id);
                        }
                    }
                    return true;
                }
                LOG.warning("Cancellation support disabled, since the '" + MessageJsonHandler.CANCEL_METHOD.getMethodName() + "' method has been registered explicitly.");
                return false;
            }
            LOG.warning("Missing 'params' attribute of cancel notification.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RequestMessage requestMessage) {
        CompletableFuture<?> future;
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setId(requestMessage.getId());
        responseMessage.setJsonrpc("2.0");
        try {
            future = this.localEndpoint.request(requestMessage.getMethod(), requestMessage.getParams());
        }
        catch (Throwable e) {
            ResponseError errorObject = this.exceptionHandler.apply(e);
            if (errorObject != null) {
                responseMessage.setError(errorObject);
                this.out.consume(responseMessage);
            }
            return;
        }
        Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
        synchronized (map) {
            this.receivedRequestMap.put(requestMessage.getId(), future);
        }
        ((CompletableFuture)((CompletableFuture)future.thenAccept(result -> {
            responseMessage.setResult(result);
            this.out.consume(responseMessage);
        })).exceptionally(t -> {
            if (this.isCancellation((Throwable)t)) {
                String message = "The request (id: " + requestMessage.getId() + ", method: '" + requestMessage.getMethod() + "') has been cancelled";
                ResponseError errorObject = new ResponseError(ResponseErrorCode.RequestCancelled, message, null);
                responseMessage.setError(errorObject);
            } else {
                ResponseError errorObject = this.exceptionHandler.apply((Throwable)t);
                if (errorObject != null) {
                    responseMessage.setError(errorObject);
                }
            }
            this.out.consume(responseMessage);
            return null;
        })).thenApply(obj -> {
            Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
            synchronized (map) {
                this.receivedRequestMap.remove(requestMessage.getId());
            }
            return null;
        });
    }

    protected boolean isCancellation(Throwable t) {
        if (t instanceof CompletionException) {
            return this.isCancellation(t.getCause());
        }
        return t instanceof CancellationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveMethod(String requestId) {
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            PendingRequestInfo requestInfo = this.sentRequestMap.get(requestId);
            if (requestInfo != null) {
                return requestInfo.requestMessage.getMethod();
            }
        }
        return null;
    }

    private static class PendingRequestInfo {
        RequestMessage requestMessage;
        Consumer<ResponseMessage> responseHandler;

        PendingRequestInfo(RequestMessage requestMessage2, Consumer<ResponseMessage> responseHandler2) {
            this.requestMessage = requestMessage2;
            this.responseHandler = responseHandler2;
        }
    }
}

