/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.detector;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.yaml.YAMLFileType;

public class DatabaseGemDetector
implements GemDetector {
    @NonNls
    private static final Pattern ADAPTER_PATTERN;
    @NonNls
    private static final MultiValuesMap<String, String> RUBY_ADAPTER_TO_GEM;
    @NonNls
    private static final MultiValuesMap<String, String> JRUBY_ADAPTER_TO_GEM;

    @NotNull
    public Set<GemDependency> detect(@NotNull Project project, @Nullable Sdk sdk, @Nullable VirtualFile provider) {
        if (project == null) {
            DatabaseGemDetector.$$$reportNull$$$0(0);
        }
        if (sdk == null || provider == null || !"database.yml".equals(provider.getName())) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                DatabaseGemDetector.$$$reportNull$$$0(1);
            }
            return set;
        }
        String contents = (String)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            PsiFile psiFile;
            if (project == null) {
                DatabaseGemDetector.$$$reportNull$$$0(5);
            }
            if ((psiFile = PsiManager.getInstance((Project)project).findFile(provider)) == null) {
                return null;
            }
            RailsApp app = RailsApp.fromPsiElement((PsiElement)psiFile);
            if (app == null || !Comparing.equal((Object)provider.getParent(), (Object)app.getConfigRoot())) {
                return null;
            }
            return psiFile.getText();
        }));
        if (StringUtil.isEmptyOrSpaces((String)contents)) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                DatabaseGemDetector.$$$reportNull$$$0(2);
            }
            return set;
        }
        Matcher matcher = ADAPTER_PATTERN.matcher(contents);
        HashSet result = new HashSet();
        Collection gems = GemManager.getInstance().getAllGems(sdk, ModuleUtilCore.findModuleForFile((VirtualFile)provider, (Project)project));
        while (matcher.find()) {
            String adapterName = matcher.group(1);
            Collection alternatives = JRubySdkUtil.isJRubySDK((Sdk)sdk) ? JRUBY_ADAPTER_TO_GEM.get((Object)adapterName) : RUBY_ADAPTER_TO_GEM.get((Object)adapterName);
            if (alternatives == null) continue;
            String dependency = (String)alternatives.iterator().next();
            if (alternatives.size() > 1) {
                for (String dep : alternatives) {
                    if (GemSearchUtil.findGem((Collection)gems, (String)dep, null) == null) continue;
                    dependency = dep;
                    break;
                }
            }
            result.add(GemDependency.any((String)dependency));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            DatabaseGemDetector.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public boolean accepts(@NotNull VirtualFile providerCandidate) {
        if (providerCandidate == null) {
            DatabaseGemDetector.$$$reportNull$$$0(4);
        }
        return providerCandidate.getFileType() == YAMLFileType.YML;
    }

    static {
        String[] keyArray;
        ADAPTER_PATTERN = Pattern.compile("^\\s*adapter:\\s*(\\S*)\\s*$", 8);
        RUBY_ADAPTER_TO_GEM = new MultiValuesMap(true);
        RUBY_ADAPTER_TO_GEM.put((Object)"sqlite", (Object)"sqlite-ruby");
        RUBY_ADAPTER_TO_GEM.put((Object)"sqlite3", (Object)"sqlite3-ruby");
        RUBY_ADAPTER_TO_GEM.putAll((Object)"postgresql", (Object[])new String[]{"pg", "postgres", "postgres-pr"});
        RUBY_ADAPTER_TO_GEM.put((Object)"mysql", (Object)"mysql");
        RUBY_ADAPTER_TO_GEM.put((Object)"amalgalite", (Object)"activerecord-amalgalite-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"dbslayer", (Object)"activerecord-dbslayer-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"interbase", (Object)"activerecord-interbase-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"odbc", (Object)"activerecord-odbc-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"sqlanywhere", (Object)"activerecord-sqlanywhere-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"firebird", (Object)"activerecord-firebird-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"frontbase", (Object)"activerecord-frontbase-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"informix", (Object)"activerecord-informix-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"openbase", (Object)"activerecord-openbase-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"oracle", (Object)"activerecord-oracle-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"sqlserver", (Object)"activerecord-sqlserver-adapter");
        RUBY_ADAPTER_TO_GEM.put((Object)"sybase", (Object)"activerecord-sybase-adapter");
        JRUBY_ADAPTER_TO_GEM = new MultiValuesMap(true);
        JRUBY_ADAPTER_TO_GEM.put((Object)"sqlite", (Object)"activerecord-jdbcsqlite3-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"sqlite3", (Object)"activerecord-jdbcsqlite3-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"postgresql", (Object)"activerecord-jdbcpostresql-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"mysql", (Object)"activerecord-jdbcmysql-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"oracle", (Object)"activerecord-jdbcoracle-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"derby", (Object)"activerecord-jdbcderby-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"h2", (Object)"activerecord-jdbch2-adapter");
        JRUBY_ADAPTER_TO_GEM.put((Object)"hsqldb", (Object)"activerecord-jdbchsqldb-adapter");
        Set keys = JRUBY_ADAPTER_TO_GEM.keySet();
        for (String key : keyArray = ArrayUtil.toStringArray((Collection)keys)) {
            JRUBY_ADAPTER_TO_GEM.putAll((Object)("jdbc" + key), JRUBY_ADAPTER_TO_GEM.get((Object)key));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/detector/DatabaseGemDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/detector/DatabaseGemDetector";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detect$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

