/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.messages;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ArrayUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileEncodingNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildPanel", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "isSafeToConvertTo", "Lcom/intellij/openapi/vfs/encoding/EncodingUtil$Magic8;", "text", "", "isSafeToReloadIn", "update", "", "Companion", "intellij.editorconfig"})
public final class EditorConfigWrongFileEncodingNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY;
    private static final Key<Boolean> HIDDEN_KEY;
    private static final String DISABLE_KEY = "editorconfig.wrong.encoding.notification.disabled";
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        FileEditor fileEditor2 = fileEditor;
        if (!(fileEditor2 instanceof TextEditor)) {
            fileEditor2 = null;
        }
        if ((TextEditor)fileEditor2 == null) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"fileEditor.editor");
        Editor editor2 = editor;
        Project project = editor2.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"editor.project ?: return null");
        Project project2 = project;
        if (editor2.getUserData(HIDDEN_KEY) != null) {
            return null;
        }
        if (PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"editorconfig") ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)file.getCharset(), (Object)StandardCharsets.UTF_8)) {
            return null;
        }
        return this.buildPanel(project2, editor2, file);
    }

    private final EditorNotificationPanel buildPanel(Project project, Editor editor, VirtualFile file) {
        EditorNotificationPanel result2 = new EditorNotificationPanel();
        result2.text(EditorConfigBundle.INSTANCE.get("notification.encoding.message"));
        String convert = EditorConfigBundle.INSTANCE.get("notification.action.convert");
        result2.createActionLabel(convert, new Runnable(this, editor, file, project){
            final /* synthetic */ EditorConfigWrongFileEncodingNotificationProvider this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            public final void run() {
                Document document = this.$editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                String string = document.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editor.document.text");
                String text = string;
                EncodingUtil.Magic8 isSafeToConvert = EditorConfigWrongFileEncodingNotificationProvider.access$isSafeToConvertTo(this.this$0, this.$file, text);
                EncodingUtil.Magic8 isSafeToReload = EditorConfigWrongFileEncodingNotificationProvider.access$isSafeToReloadIn(this.this$0, this.$file, text);
                ChangeFileEncodingAction.changeTo((Project)this.$project, (Document)this.$editor.getDocument(), (Editor)this.$editor, (VirtualFile)this.$file, (Charset)StandardCharsets.UTF_8, (EncodingUtil.Magic8)isSafeToConvert, (EncodingUtil.Magic8)isSafeToReload);
            }
            {
                this.this$0 = editorConfigWrongFileEncodingNotificationProvider;
                this.$editor = editor;
                this.$file = virtualFile;
                this.$project = project;
            }
        });
        String hide = EditorConfigBundle.INSTANCE.get("notification.action.hide.once");
        result2.createActionLabel(hide, new Runnable(this, editor, file, project){
            final /* synthetic */ EditorConfigWrongFileEncodingNotificationProvider this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            public final void run() {
                EditorConfigWrongFileEncodingNotificationProvider.access$Companion();
                this.$editor.putUserData(EditorConfigWrongFileEncodingNotificationProvider.access$getHIDDEN_KEY$cp(), (Object)true);
                EditorConfigWrongFileEncodingNotificationProvider.access$update(this.this$0, this.$file, this.$project);
            }
            {
                this.this$0 = editorConfigWrongFileEncodingNotificationProvider;
                this.$editor = editor;
                this.$file = virtualFile;
                this.$project = project;
            }
        });
        String hideForever = EditorConfigBundle.INSTANCE.get("notification.action.hide.forever");
        result2.createActionLabel(hideForever, new Runnable(this, file, project){
            final /* synthetic */ EditorConfigWrongFileEncodingNotificationProvider this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            public final void run() {
                PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                EditorConfigWrongFileEncodingNotificationProvider.access$Companion();
                propertiesComponent.setValue("editorconfig.wrong.encoding.notification.disabled", true);
                EditorConfigWrongFileEncodingNotificationProvider.access$update(this.this$0, this.$file, this.$project);
            }
            {
                this.this$0 = editorConfigWrongFileEncodingNotificationProvider;
                this.$file = virtualFile;
                this.$project = project;
            }
        });
        return result2;
    }

    private final void update(VirtualFile file, Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private final EncodingUtil.Magic8 isSafeToReloadIn(VirtualFile file, CharSequence text) {
        byte[] byArray;
        byte[] byArray2 = file.contentsToByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"file.contentsToByteArray()");
        byte[] bytes = byArray2;
        byte[] bom = file.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)StandardCharsets.UTF_8, (byte[])bom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)StandardCharsets.UTF_8);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        String loaded = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)StandardCharsets.UTF_8)).toString();
        try {
            String string = FileDocumentManager.getInstance().getLineSeparator(file, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileDocumentManager.getI\u2026LineSeparator(file, null)");
            String separator = string;
            String string2 = StringUtil.convertLineSeparators((String)loaded, (String)separator);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.convertLineSe\u2026rators(loaded, separator)");
            String string3 = string2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string4.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = byArray3;
        }
        catch (UnsupportedOperationException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        catch (NullPointerException e) {
            return EncodingUtil.Magic8.NO_WAY;
        }
        byte[] bytesToSave = byArray;
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            byte[] byArray4 = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"ArrayUtil.mergeArrays(bom, bytesToSave)");
            bytesToSave = byArray4;
        }
        return !Arrays.equals(bytesToSave, bytes) ? EncodingUtil.Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
    }

    private final EncodingUtil.Magic8 isSafeToConvertTo(VirtualFile file, CharSequence text) {
        EncodingUtil.Magic8 magic8;
        try {
            CharSequence charSequence;
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] bytesOnDisk = byArray;
            String string = FileDocumentManager.getInstance().getLineSeparator(file, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileDocumentManager.getI\u2026LineSeparator(file, null)");
            String lineSeparator = string;
            if (Intrinsics.areEqual((Object)lineSeparator, (Object)"\n")) {
                charSequence = text;
            } else {
                CharSequence charSequence2 = StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
                charSequence = charSequence2;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"StringUtilRt.convertLine\u2026tors(text, lineSeparator)");
            }
            CharSequence textToSave = charSequence;
            byte[] saved = (byte[])LoadTextUtil.chooseMostlyHarmlessCharset((Charset)file.getCharset(), (Charset)StandardCharsets.UTF_8, (String)((Object)textToSave).toString()).second;
            CharSequence charSequence3 = LoadTextUtil.getTextByBinaryPresentation((byte[])saved, (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence3, (String)"LoadTextUtil.getTextByBi\u2026, StandardCharsets.UTF_8)");
            CharSequence textLoadedBack = charSequence3;
            magic8 = !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? EncodingUtil.Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            magic8 = EncodingUtil.Magic8.NO_WAY;
        }
        return magic8;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"editorconfig.wrong.encoding.notification");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<EditorNotific\u2026g.encoding.notification\")");
        KEY = key;
        Key key2 = Key.create((String)"editorconfig.wrong.encoding.notification.hidden");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<Boolean>(\"edi\u2026ing.notification.hidden\")");
        HIDDEN_KEY = key2;
    }

    @NotNull
    public static final /* synthetic */ EncodingUtil.Magic8 access$isSafeToConvertTo(EditorConfigWrongFileEncodingNotificationProvider $this, @NotNull VirtualFile file, @NotNull CharSequence text) {
        return $this.isSafeToConvertTo(file, text);
    }

    @NotNull
    public static final /* synthetic */ EncodingUtil.Magic8 access$isSafeToReloadIn(EditorConfigWrongFileEncodingNotificationProvider $this, @NotNull VirtualFile file, @NotNull CharSequence text) {
        return $this.isSafeToReloadIn(file, text);
    }

    @NotNull
    public static final /* synthetic */ Key access$getHIDDEN_KEY$cp() {
        return HIDDEN_KEY;
    }

    public static final /* synthetic */ void access$update(EditorConfigWrongFileEncodingNotificationProvider $this, @NotNull VirtualFile file, @NotNull Project project) {
        $this.update(file, project);
    }

    @NotNull
    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\n0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileEncodingNotificationProvider$Companion;", "", "()V", "DISABLE_KEY", "", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "KEY", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

