/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ShortcutsCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowWhitelistEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ToolWindowsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class ToolWindowCollector
implements PersistentStateComponent<State> {
    private static final String UNKNOWN = "unknown_by_";
    public static final Set<String> ourToolwindowWhitelist = new HashSet<String>();
    private State myState = new State();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    public ToolWindowCollector() {
        for (ToolWindowWhitelistEP extension : (ToolWindowWhitelistEP[])ToolWindowWhitelistEP.EP_NAME.getExtensions()) {
            if (!StatisticsUtilKt.isDevelopedByJetBrains(extension.getPluginId())) continue;
            ourToolwindowWhitelist.add(extension.id);
        }
        ShortcutsCollector.getInstance();
        OutdatedToolWindowCollector.getInstance();
    }

    public void recordActivation(String toolWindowId) {
        this.record(toolWindowId, "Activation");
    }

    public void recordClick(String toolWindowId) {
        this.record(toolWindowId, "Click");
    }

    private void record(@Nullable String toolWindowId, @NotNull String source) {
        if (source == null) {
            ToolWindowCollector.$$$reportNull$$$0(0);
        }
        if (toolWindowId == null) {
            return;
        }
        boolean isWhitelisted = ourToolwindowWhitelist.contains(toolWindowId) || ToolWindowCollector.isDevelopedByJetBrains(toolWindowId);
        String key = ConvertUsagesUtil.escapeDescriptorName(isWhitelisted ? toolWindowId + " by " + source : UNKNOWN + source);
        FeatureUsageLogger.INSTANCE.log("toolwindow.v2", key, FUSUsageContext.OS_CONTEXT.getData());
    }

    public static boolean isDevelopedByJetBrains(@NotNull String toolWindowId) {
        boolean isByJB;
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(1);
        }
        isByJB = (isByJB = ToolWindowCollector.isDevelopedByJetBrains(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions())) || ToolWindowCollector.isDevelopedByJetBrains(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        isByJB = isByJB || ToolWindowCollector.isDevelopedByJetBrains(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        return isByJB;
    }

    public static boolean isDevelopedByJetBrains(@NotNull String toolWindowId, @NotNull ToolWindowEP[] toolWindows) {
        if (toolWindowId == null) {
            ToolWindowCollector.$$$reportNull$$$0(2);
        }
        if (toolWindows == null) {
            ToolWindowCollector.$$$reportNull$$$0(3);
        }
        for (ToolWindowEP ep : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep.id)) continue;
            return StatisticsUtilKt.isDevelopedByJetBrains(ep.getPluginId());
        }
        return false;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ToolWindowCollector.$$$reportNull$$$0(4);
        }
    }

    static {
        ourToolwindowWhitelist.add(ToolWindowId.COMMANDER);
        ourToolwindowWhitelist.add(ToolWindowId.MESSAGES_WINDOW);
        ourToolwindowWhitelist.add(ToolWindowId.PROJECT_VIEW);
        ourToolwindowWhitelist.add(ToolWindowId.STRUCTURE_VIEW);
        ourToolwindowWhitelist.add(ToolWindowId.FAVORITES_VIEW);
        ourToolwindowWhitelist.add(ToolWindowId.ANT_BUILD);
        ourToolwindowWhitelist.add(ToolWindowId.DEBUG);
        ourToolwindowWhitelist.add(ToolWindowId.RUN);
        ourToolwindowWhitelist.add(ToolWindowId.BUILD);
        ourToolwindowWhitelist.add(ToolWindowId.FIND);
        ourToolwindowWhitelist.add(ToolWindowId.CVS);
        ourToolwindowWhitelist.add(ToolWindowId.HIERARCHY);
        ourToolwindowWhitelist.add(ToolWindowId.INSPECTION);
        ourToolwindowWhitelist.add(ToolWindowId.TODO_VIEW);
        ourToolwindowWhitelist.add(ToolWindowId.DEPENDENCIES);
        ourToolwindowWhitelist.add(ToolWindowId.VCS);
        ourToolwindowWhitelist.add(ToolWindowId.MODULES_DEPENDENCIES);
        ourToolwindowWhitelist.add(ToolWindowId.DUPLICATES);
        ourToolwindowWhitelist.add(ToolWindowId.EXTRACT_METHOD);
        ourToolwindowWhitelist.add(ToolWindowId.DOCUMENTATION);
        ourToolwindowWhitelist.add(ToolWindowId.TASKS);
        ourToolwindowWhitelist.add(ToolWindowId.DATABASE_VIEW);
        ourToolwindowWhitelist.add(ToolWindowId.PREVIEW);
        ourToolwindowWhitelist.add(ToolWindowId.RUN_DASHBOARD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindows";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "record";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDevelopedByJetBrains";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @com.intellij.openapi.components.State(name="ToolWindowCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
    public static class OutdatedToolWindowCollector
    implements PersistentStateComponent<State> {
        public static OutdatedToolWindowCollector getInstance() {
            return (OutdatedToolWindowCollector)ServiceManager.getService(OutdatedToolWindowCollector.class);
        }

        @Nullable
        public State getState() {
            return new State();
        }

        public void loadState(@NotNull State state) {
            if (state == null) {
                OutdatedToolWindowCollector.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/internal/statistic/collectors/fus/actions/persistence/ToolWindowCollector$OutdatedToolWindowCollector", "loadState"));
        }
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="toolWindow", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

