/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.StringLiteralToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetLexer {
    private static final String DELIMS = ">^+*|()[]{}.#,='\" \u0000";

    @Nullable
    public List<ZenCodingToken> lex(@NotNull String text) {
        if (text == null) {
            EmmetLexer.$$$reportNull$$$0(0);
        }
        text = text + '\u0000';
        ArrayList<ZenCodingToken> result2 = new ArrayList<ZenCodingToken>();
        boolean inQuotes = false;
        boolean inApostrophes = false;
        int bracesStack = 0;
        StringBuilder builder2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (inQuotes) {
                builder2.append(c);
                if (c != '\"') continue;
                inQuotes = false;
                result2.add(new StringLiteralToken(builder2.toString()));
                builder2 = new StringBuilder();
                continue;
            }
            if (inApostrophes) {
                builder2.append(c);
                if (c != '\'') continue;
                inApostrophes = false;
                result2.add(new StringLiteralToken(builder2.toString()));
                builder2 = new StringBuilder();
                continue;
            }
            if (bracesStack > 0) {
                builder2.append(c);
                if (c == '}') {
                    if (--bracesStack != 0) continue;
                    result2.add(new TextToken(builder2.toString()));
                    builder2 = new StringBuilder();
                    continue;
                }
                if (c != '{') continue;
                ++bracesStack;
                continue;
            }
            if (DELIMS.indexOf(c) < 0) {
                builder2.append(c);
                continue;
            }
            if (c == '+' && (i == text.length() - 2 || text.charAt(i + 1) == ')')) {
                builder2.append(c);
                continue;
            }
            if (builder2.length() > 0) {
                String tokenText = builder2.toString();
                int n = StringUtil.parseInt((String)tokenText, (int)-1);
                if (!StringUtil.startsWithChar((CharSequence)tokenText, (char)'0') && n >= 0) {
                    result2.add(new NumberToken(n));
                } else {
                    result2.add(new IdentifierToken(tokenText));
                }
                builder2 = new StringBuilder();
            }
            if (c == '\"') {
                inQuotes = true;
                builder2.append(c);
                continue;
            }
            if (c == '\'') {
                inApostrophes = true;
                builder2.append(c);
                continue;
            }
            if (c == '{') {
                bracesStack = 1;
                builder2.append(c);
                continue;
            }
            if (c == '(') {
                result2.add(ZenCodingTokens.OPENING_R_BRACKET);
                continue;
            }
            if (c == ')') {
                result2.add(ZenCodingTokens.CLOSING_R_BRACKET);
                continue;
            }
            if (c == '[') {
                result2.add(ZenCodingTokens.OPENING_SQ_BRACKET);
                continue;
            }
            if (c == ']') {
                result2.add(ZenCodingTokens.CLOSING_SQ_BRACKET);
                continue;
            }
            if (c == '=') {
                result2.add(ZenCodingTokens.EQ);
                continue;
            }
            if (c == '.') {
                result2.add(ZenCodingTokens.DOT);
                continue;
            }
            if (c == '#') {
                result2.add(ZenCodingTokens.SHARP);
                continue;
            }
            if (c == ',') {
                result2.add(ZenCodingTokens.COMMA);
                continue;
            }
            if (c == ' ') {
                result2.add(ZenCodingTokens.SPACE);
                continue;
            }
            if (c == '|') {
                result2.add(ZenCodingTokens.PIPE);
                continue;
            }
            if (c == '\u0000') continue;
            result2.add(new OperationToken(c));
        }
        if (bracesStack != 0 || inQuotes || inApostrophes) {
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/EmmetLexer", "lex"));
    }
}

