/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;

public class TextMateThemeMappingPanel
implements Disposable {
    private String[] myTmThemeNames;
    private final String[] myIdeaThemeNames;
    private final TableView<Map.Entry<String, String>> myThemeMappingTable;
    private final ListTableModel<Map.Entry<String, String>> myThemeMappingModel;
    private final DynamicThemeColumn myTmThemeColumn;
    private final TextMateService.TextMateBundleListener myListener;

    public TextMateThemeMappingPanel(@NotNull String[] tmThemeNames, @NotNull String[] ideaThemeNames) {
        if (tmThemeNames == null) {
            TextMateThemeMappingPanel.$$$reportNull$$$0(0);
        }
        if (ideaThemeNames == null) {
            TextMateThemeMappingPanel.$$$reportNull$$$0(1);
        }
        this.myTmThemeNames = tmThemeNames;
        this.myIdeaThemeNames = ideaThemeNames;
        this.myTmThemeColumn = new DynamicThemeColumn(TextMateThemeMappingPanel.findLongestString(this.myTmThemeNames));
        ColumnInfo[] columns = new ColumnInfo[]{new StaticThemeColumn(TextMateThemeMappingPanel.findLongestString(this.myIdeaThemeNames)), this.myTmThemeColumn};
        this.myThemeMappingModel = new ListTableModel(columns, new ArrayList(), 0);
        this.myThemeMappingTable = new TableView(this.myThemeMappingModel);
        this.myThemeMappingTable.setBorder(null);
        this.myThemeMappingTable.setShowGrid(false);
        this.myThemeMappingTable.updateColumnSizes();
        this.myThemeMappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myListener = new TextMateService.TextMateBundleListener(){

            @Override
            public void colorSchemeChanged() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    TextMateThemeMappingPanel.this.updateTextMateThemeNamesColumn();
                    TextMateThemeMappingPanel.this.myThemeMappingTable.updateUI();
                });
            }
        };
        TextMateService.getInstance().addListener(this.myListener);
    }

    public void dispose() {
        TextMateService.getInstance().removeListener(this.myListener);
    }

    @Nullable
    private static String findLongestString(@NotNull String[] names) {
        if (names == null) {
            TextMateThemeMappingPanel.$$$reportNull$$$0(2);
        }
        String maxString = null;
        for (String name : names) {
            if (maxString != null && maxString.length() >= name.length()) continue;
            maxString = name;
        }
        return maxString;
    }

    public void reset(TextMateSettings settings) {
        this.updateTextMateThemeNamesColumn();
        Map<String, String> mapping = this.getDefaultThemesMapping(settings);
        TextMateService textMateService = TextMateService.getInstance();
        for (String name : this.myIdeaThemeNames) {
            mapping.put(name, settings.getTextMateThemeName(name, textMateService));
        }
        this.myThemeMappingModel.setItems((List)ContainerUtil.newArrayList(mapping.entrySet()));
    }

    private void updateTextMateThemeNamesColumn() {
        this.myTmThemeNames = TextMateService.getInstance().getThemeNames();
        this.myTmThemeColumn.setMaxStringValue(TextMateThemeMappingPanel.findLongestString(this.myTmThemeNames));
    }

    public Map<String, String> getDefaultThemesMapping(@NotNull TextMateSettings settings) {
        if (settings == null) {
            TextMateThemeMappingPanel.$$$reportNull$$$0(3);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        TextMateService textMateService = TextMateService.getInstance();
        for (String name : this.myIdeaThemeNames) {
            result.put(name, settings.getTextMateThemeName(name, textMateService));
        }
        return result;
    }

    public void apply(TextMateSettings.TextMateSettingsState state) {
        List tableItems = this.myThemeMappingTable.getItems();
        Map mapping = ContainerUtilRt.newHashMap((int)tableItems.size());
        for (Map.Entry entry : tableItems) {
            mapping.put(entry.getKey(), entry.getValue());
        }
        state.setThemesMapping(mapping);
    }

    public JPanel getMainComponent() {
        return ToolbarDecorator.createDecorator(this.myThemeMappingTable).setPreferredSize(new Dimension((int)this.myThemeMappingTable.getPreferredSize().getWidth(), (int)this.myThemeMappingTable.getPreferredScrollableViewportSize().getWidth())).setToolbarBorder(null).disableAddAction().disableRemoveAction().disableUpDownActions().createPanel();
    }

    public boolean isModified(Map<String, String> themesMapping) {
        for (Map.Entry entry : this.myThemeMappingTable.getItems()) {
            String oldValue = themesMapping.get(entry.getKey());
            if (oldValue != null && oldValue.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmThemeNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaThemeNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateThemeMappingPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findLongestString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultThemesMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StaticThemeColumn
    extends ColumnInfo<Map.Entry<String, String>, String> {
        private final String myMaxStringValue;

        StaticThemeColumn(String maxStringValue) {
            super("IDE Color Scheme");
            this.myMaxStringValue = maxStringValue == null || this.getName().length() > maxStringValue.length() ? this.getName() : maxStringValue;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.myMaxStringValue;
        }

        public int getAdditionalWidth() {
            return 10;
        }

        @Nullable
        public String valueOf(Map.Entry<String, String> mapping) {
            return mapping.getKey();
        }
    }

    private class DynamicThemeColumn
    extends ColumnInfo<Map.Entry<String, String>, String> {
        private String myMaxStringValue;
        private final DefaultTableCellRenderer myCellRenderer;

        DynamicThemeColumn(String maxStringValue) {
            super("TextMate Color Scheme");
            this.myCellRenderer = new DefaultTableCellRenderer(){
                private final JBComboBoxLabel myLabel = new JBComboBoxLabel();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.myLabel.setTextFont(table.getFont());
                    String themeName = String.valueOf(value);
                    this.myLabel.setText(themeName);
                    if (isSelected) {
                        this.myLabel.setSelectionIcon();
                    } else {
                        this.myLabel.setRegularIcon();
                    }
                    this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    if (!isSelected && !ArrayUtil.contains((String)themeName, (String[])TextMateThemeMappingPanel.this.myTmThemeNames)) {
                        this.myLabel.setForeground((Color)JBColor.RED);
                    }
                    return this.myLabel;
                }
            };
            this.setMaxStringValue(maxStringValue);
        }

        public void setMaxStringValue(@Nullable String maxStringValue) {
            this.myMaxStringValue = maxStringValue == null || this.getName().length() > maxStringValue.length() ? this.getName() : maxStringValue;
        }

        public TableCellRenderer getRenderer(Map.Entry<String, String> mapping) {
            return this.myCellRenderer;
        }

        public TableCellEditor getEditor(final Map.Entry<String, String> mapping) {
            final JBComboBoxTableCellEditorComponent themeChooser = new JBComboBoxTableCellEditorComponent();
            themeChooser.setWide(true);
            themeChooser.setText(mapping.getValue());
            themeChooser.setFont(TextMateThemeMappingPanel.this.myThemeMappingTable.getFont());
            themeChooser.setOptions((Object[])TextMateThemeMappingPanel.this.myTmThemeNames);
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    return themeChooser.getEditorValue();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    themeChooser.setCell(table, row, column);
                    int defaultValueIndex = ArrayUtil.find((Object[])TextMateThemeMappingPanel.this.myTmThemeNames, mapping.getValue());
                    themeChooser.setDefaultValue(defaultValueIndex > -1 ? TextMateThemeMappingPanel.this.myTmThemeNames[defaultValueIndex] : null);
                    themeChooser.setToString(o -> (String)o);
                    return themeChooser;
                }
            };
        }

        public void setValue(Map.Entry<String, String> mapping, String colorScheme) {
            if (colorScheme != null) {
                mapping.setValue(colorScheme.isEmpty() ? "Mac Classic" : colorScheme);
            }
        }

        public boolean isCellEditable(Map.Entry<String, String> entry) {
            return true;
        }

        public TableCellRenderer getCustomizedRenderer(Map.Entry<String, String> o, TableCellRenderer renderer) {
            return super.getCustomizedRenderer(o, renderer);
        }

        @Nullable
        public String getMaxStringValue() {
            return this.myMaxStringValue;
        }

        public int getAdditionalWidth() {
            return 10;
        }

        @Nullable
        public String valueOf(Map.Entry<String, String> mapping) {
            return mapping.getValue();
        }
    }
}

