.\"
.\" $(TROFF) $(MANMACROS) file | $(PRINTER)
.\"
.TH RTF2TROFF 1
.UC 4
.SH NAME
rtf2troff \- convert Rich Text Format documents to \fItroff\fR
.SH SYNTAX
.B rtf2troff
[
.B \-e
] [
.B \-h|+h
] [
.B \-man|\-me|\-mm|\-ms
] [
.B \-s|+s
] [
.B \-t
.I troff
] [
.B \-u|+u
] [
.I file
]
.SH DESCRIPTION
.I rtf2troff
converts documents written in Rich Text Format (RTF)
to
.I troff
format.
.PP
Optional flags may be given to modify the operation of
.IR rtf2troff ,
as follows:
.TP
.B \-e
Turn on token echoing.
This causes each token read from the input file to be echoed to the
output.
Not normally useful except for debugging.
.TP
.B \-h
Turn off header/footer output.
This is the default, since most of the time you'll probably run the output
through
.I troff
using a macro package that supplies its own header and footer macros.
.TP
.B \+h
Turn on header/footer output.
.I rtf2troff
attempts to write header and footer traps.
.TP
.BI \-m xx
Specify macro package, one of
.BR \-man ,
.BR \-me ,
.BR \-mm ,
or
.BR \-ms .
This usually has little effect, although there are some minor tweaks made
to the output that can be macro-package-specific.
.TP
.B \-s
Disallow strikethrough output.
.I rtf2troff
simulates strikethrough output by generating
.I troff
output that prints the struck-through character, backs up, and prints
a line through the character.
This works reasonably well, but the
.I troff
output is hideous and difficult to edit.
.TP
.B \+s
Allow strikethrough output.
This is the default.
.TP
.BI \-t \ troff
Specify version of
.I troff
for which output should be written.
The default is
.IR groff .
Other reasonable versions, if you have them, are
.I dwbtroff
and
.IR pstroff .
.TP
.B \-u
Disallow underlined output.
.I rtf2troff
simulates underlining by generating
.I troff
output that prints the underlined character, backs up, and prints
an underscore.
This works reasonably well, but the
.I troff
output is hideous and difficult to edit.
.TP
.B \+u
Allow underlined output.
This is the default.
.SH "SEE ALSO"
troff2rtf(1)
.SH "WHO-TO-BLAME"
Paul DuBois, dubois@primate.wisc.edu
