/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IdrefReference
implements PsiReference {
    private final XmlAttributeValue referenceElement;

    IdrefReference(XmlAttributeValue referenceElement) {
        this.referenceElement = referenceElement;
    }

    @NotNull
    public PsiElement getElement() {
        XmlAttributeValue xmlAttributeValue = this.referenceElement;
        if (xmlAttributeValue == null) {
            IdrefReference.$$$reportNull$$$0(0);
        }
        return xmlAttributeValue;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ElementManipulators.getManipulator((PsiElement)this.referenceElement).getRangeInElement((PsiElement)this.referenceElement);
        if (textRange == null) {
            IdrefReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        String text = this.referenceElement.getText();
        if (text.length() - 1 < 1) {
            return null;
        }
        String strippedText = text.substring(1, text.length() - 1);
        return IdrefReference.findIDAttribute(this.referenceElement.getContainingFile(), strippedText);
    }

    private static XmlAttribute findIDAttribute(PsiFile containingFile, final String strippedText) {
        final XmlAttribute[] out = new XmlAttribute[1];
        XmlRecursiveElementVisitor visitor = new XmlRecursiveElementVisitor(){

            public void visitElement(PsiElement psiElement) {
                if (out[0] != null) {
                    return;
                }
                super.visitElement(psiElement);
            }

            public void visitXmlAttribute(XmlAttribute xmlAttribute) {
                if (out[0] != null) {
                    return;
                }
                super.visitXmlAttribute(xmlAttribute);
                if ("id".equalsIgnoreCase(xmlAttribute.getName()) && strippedText.equals(xmlAttribute.getValue())) {
                    out[0] = xmlAttribute;
                }
            }
        };
        containingFile.accept((PsiElementVisitor)visitor);
        return out[0];
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.referenceElement.getText();
        if (string == null) {
            IdrefReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            IdrefReference.$$$reportNull$$$0(3);
        }
        XmlAttribute attribute = (XmlAttribute)this.referenceElement.getParent();
        attribute.setValue(newElementName);
        XmlAttributeValue out = attribute.getValueElement();
        assert (out != null);
        return out;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            IdrefReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            IdrefReference.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return false;
        }
        if (!(element instanceof XmlAttribute)) {
            return false;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)element;
        if (!"id".equalsIgnoreCase(xmlAttribute.getName())) {
            return false;
        }
        return element.equals(this.resolve());
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/references/IdrefReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/references/IdrefReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

