/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.UnknownDatabaseIntermediateFacade;

public final class UnknownDatabaseProvider
extends JdbcIntermediateRdbmsProvider {
    private static final Pattern CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:.+$");

    @Override
    @NotNull
    public Rdbms rdbms() {
        return UnknownDatabase.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 90;
    }

    @Override
    @Nullable
    protected String getConnectionStringExample() {
        return null;
    }

    @Override
    @Nullable
    protected Driver loadDriver(String connectionString) {
        return null;
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return UnknownDatabaseExceptionRecognizer.INSTANCE;
    }

    @Override
    @NotNull
    protected JdbcIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new UnknownDatabaseIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, this.getExceptionRecognizer());
    }
}

