/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.intellij.docker.agent.AgentLogConfigurator;
import com.intellij.docker.agent.AgentLogSettings;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContainerImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentDeploymentImpl;
import com.intellij.docker.agent.DockerAgentImageImpl;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PullImageResultCallbackImpl;
import com.intellij.docker.agent.fix.FixedDockerCmdExecNettyFactoryCopyImpl;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class DockerAgentImpl
implements DockerAgent {
    private static final String HTTPS_ERROR_MESSAGE = "https protocol is not supported";
    private static final String REGISTRY_AUTH_SUCCESS = "Login Succeeded";
    private static final String HTTPS_ERROR_MESSAGE_HINT = "<br/>Please check if path to certificates folder is specified and correct.<br/>Please also note, you don't need to specify path to certificates folder if use unsecured http connection on Linux.";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String TCP_PROTOCOL_PREFIX = "tcp://";
    private final LogAgentManager myLogManager = new LogAgentManager();
    private DockerClient myClient;
    private CloudAgentLogger myLogger;
    private CloudAgentErrorHandler myErrorHandler;
    private DockerClientConfig myClientConfig;
    private AgentLogSettings myLogSettings;

    public void setLogSettings(AgentLogSettings settings) {
        this.myLogSettings = settings;
    }

    public void connect(final DockerAgentConfig config, CloudAgentLogger logger, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger;
        this.myErrorHandler = errorHandler;
        if (config.isDoNotConnect()) {
            return;
        }
        new ApiTaskBase(errorHandler){

            @Override
            protected Object doPerform() throws ApiTaskException {
                DefaultDockerClientConfig.Builder builder;
                AgentLogConfigurator.configure(DockerAgentImpl.this.myLogSettings);
                try {
                    builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
                }
                catch (IllegalArgumentException e) {
                    builder = new DefaultDockerClientConfig.Builder();
                }
                DockerAgentImpl.this.myClientConfig = (DockerClientConfig)builder.withDockerHost(DockerAgentImpl.getDockerHost(config.getApiUrl())).withDockerTlsVerify(Boolean.valueOf(DockerAgentImpl.isTlsVerifyEnabled(config.getApiUrl()))).withDockerCertPath(config.getCertificatesPath()).withApiVersion(RemoteApiVersion.VERSION_1_24).build();
                DockerClientBuilder clientBuilder = DockerClientBuilder.getInstance((DockerClientConfig)DockerAgentImpl.this.myClientConfig);
                FixedDockerCmdExecNettyFactoryCopyImpl nettyCmdExecFactory = new FixedDockerCmdExecNettyFactoryCopyImpl();
                clientBuilder.withDockerCmdExecFactory((DockerCmdExecFactory)nettyCmdExecFactory);
                DockerAgentImpl.this.myClient = clientBuilder.build();
                DockerAgentImpl.this.myClient.pingCmd().exec();
                return null;
            }

            @Override
            protected void onError(String error) {
                if (error.contains(DockerAgentImpl.HTTPS_ERROR_MESSAGE)) {
                    error = error + DockerAgentImpl.HTTPS_ERROR_MESSAGE_HINT;
                }
                super.onError(error);
            }
        }.perform();
    }

    private static String getDockerHost(String url) {
        if (url == null) {
            return null;
        }
        for (String prefix : new String[]{HTTP_PROTOCOL_PREFIX, HTTPS_PROTOCOL_PREFIX}) {
            if (!url.startsWith(prefix)) continue;
            return TCP_PROTOCOL_PREFIX + url.substring(prefix.length());
        }
        return url;
    }

    private static boolean isTlsVerifyEnabled(String url) {
        return url != null && url.startsWith(HTTPS_PROTOCOL_PREFIX);
    }

    public void disconnect() {
        this.myLogManager.stopListeningAllLogs();
    }

    public DockerAgentApplication[] getApplications() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
                DockerAgentImpl.this.collectImages(result, null);
            }
        }.perform();
    }

    public DockerAgentApplication[] getImages(final String label) {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectImages(result, label);
            }
        }.perform();
    }

    private void collectImages(List<DockerAgentApplication> result, String label) {
        ListImagesCmd listImagesCmd = this.myClient.listImagesCmd();
        if (label != null) {
            listImagesCmd.withLabelFilter(new String[]{label});
        }
        List images = (List)listImagesCmd.exec();
        for (Image image : images) {
            result.add(new DockerAgentImageImpl(new DockerAgentContextImpl(), image));
        }
    }

    public DockerAgentApplication[] getContainers() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
            }
        }.perform();
    }

    private void collectContainers(List<DockerAgentApplication> result) {
        List containers = (List)this.myClient.listContainersCmd().withShowAll(Boolean.TRUE).exec();
        for (Container container : containers) {
            result.add(new DockerAgentContainerImpl(new DockerAgentContextImpl(), container));
        }
    }

    public void removeVolume(final String volumeName) {
        new ApiTaskBase(this.myErrorHandler){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentImpl.this.myClient.removeVolumeCmd(volumeName).exec();
                return null;
            }
        }.perform();
    }

    static StringBuilder appendAll(StringBuilder builder, String ... items) {
        if (items == null) {
            builder.append("<unknown>");
            return builder;
        }
        boolean first = true;
        TreeSet<String> sortedItems = new TreeSet<String>(Arrays.asList(items));
        for (String item : sortedItems) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(item);
        }
        return builder;
    }

    public OngoingProcess pullImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<PullImageResultCallbackImpl>(this.myErrorHandler){

            @Override
            protected PullImageResultCallbackImpl doPerform() throws IOException, ApiTaskException {
                String tag;
                PullImageCmd pullImageCmd = DockerAgentImpl.this.myClient.pullImageCmd(repositoryConfig.getQualifiedRepository());
                DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
                if (customAuthConfig != null) {
                    pullImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
                }
                if ((tag = repositoryConfig.getTag()) != null) {
                    pullImageCmd.withTag(tag);
                }
                return (PullImageResultCallbackImpl)pullImageCmd.exec((ResultCallback)new PullImageResultCallbackImpl(progressCallback, DockerAgentImpl.this.myLogger));
            }
        }.perform();
    }

    public void imageRegistryAuth(final DockerAuthConfig authConfig) {
        new ApiTaskBase(this.myErrorHandler){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                AuthResponse authResponse = DockerAgentImpl.this.myClient.authCmd().withAuthConfig((AuthConfig)new AuthConfigEx(authConfig)).exec();
                String status = authResponse.getStatus();
                if (!DockerAgentImpl.REGISTRY_AUTH_SUCCESS.equals(status)) {
                    throw new ApiTaskException(status);
                }
                return null;
            }
        }.perform();
    }

    public DockerAgentDeployment createDeployment(DockerAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler, DockerAgentPathMapper pathMapper) {
        return new DockerAgentDeploymentImpl(new DockerAgentContextImpl(), config, loggingHandler, pathMapper);
    }

    private abstract class ApplicationsApiTaskBase
    extends ApiTaskBase<DockerAgentApplication[]> {
        ApplicationsApiTaskBase() {
            super(DockerAgentImpl.this.myErrorHandler);
        }

        @Override
        protected DockerAgentApplication[] doPerform() throws IOException, ApiTaskException {
            ArrayList<DockerAgentApplication> result = new ArrayList<DockerAgentApplication>();
            this.collectApplications(result);
            return result.toArray(DockerAgentApplication.EMPTY_ARRAY);
        }

        protected abstract void collectApplications(List<DockerAgentApplication> var1);
    }

    private class DockerAgentContextImpl
    implements DockerAgentContext {
        private DockerAgentContextImpl() {
        }

        @Override
        public DockerAgent getAgent() {
            return DockerAgentImpl.this;
        }

        @Override
        public DockerClient getClient() {
            return DockerAgentImpl.this.myClient;
        }

        @Override
        public CloudAgentErrorHandler getErrorHandler() {
            return DockerAgentImpl.this.myErrorHandler;
        }

        @Override
        public LogAgentManager getLogManager() {
            return DockerAgentImpl.this.myLogManager;
        }

        @Override
        public CloudAgentLogger getLogger() {
            return DockerAgentImpl.this.myLogger;
        }

        @Override
        public DockerClientConfig getClientConfig() {
            return DockerAgentImpl.this.myClientConfig;
        }
    }
}

