/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.LafIconLookup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper {
    @NonNls
    private static final String q = "structural.search.recursive";
    @NonNls
    private static final String r = "structural.search.match.case";
    @NonNls
    private static final String m = "structural.search.shorten.fqn";
    @NonNls
    private static final String g = "structural.search.reformat";
    @NonNls
    private static final String d = "structural.search.use.static.import";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH;
    public static final String USER_DEFINED;
    private final SearchContext h;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    FileType myFileType;
    Language myDialect;
    String myContext;
    private final Alarm k;
    private boolean n;
    private final boolean i;
    private boolean j;
    boolean myFilterButtonEnabled;
    JCheckBox myRecursive;
    private JCheckBox c;
    private JCheckBox f;
    private JCheckBox b;
    private JCheckBox a;
    FileTypeSelector myFileTypesComboBox;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter o;
    FilterPanel myFilterPanel;
    private LinkComboBox p;
    private ScopePanel l;
    private JCheckBox e;
    JComponent myReplacePanel;
    private static final long s;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        long l3 = s ^ 0xCA091646914L;
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myDialect = null;
        this.myContext = null;
        this.myFilterButtonEnabled = false;
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.i = editConfigOnly;
        this.h = searchContext;
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.a(ActionManager.getInstance().getAction("StructuralSearchPlugin.StructuralSearchAction"), false);
        this.a(ActionManager.getInstance().getAction("StructuralSearchPlugin.StructuralReplaceAction"), true);
        this.k = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(searchContext.getProject(), new ProjectManagerListener(){
            private static final long a = lb.a(-2155646181141133496L, -2919151456913544958L, MethodHandles.lookup().lookupClass()).a(14881211078708L);

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.a(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x23FD358419F2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "projectClosing"));
            }
        });
    }

    private void a(final AnAction anAction, final boolean bl2) {
        new AnAction(){
            private static final long a = lb.a(795710086043031122L, 3473201744725143394L, MethodHandles.lookup().lookupClass()).a(113386910344055L);

            public boolean isDumbAware() {
                return anAction.isDumbAware();
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                if (StructuralSearchDialog.this.myReplace == bl2) {
                    return;
                }
                StructuralSearchDialog.this.myReplace = bl2;
                StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
                StructuralSearchDialog.this.myReplacePanel.setVisible(bl2);
                StructuralSearchDialog.this.myRecursive.setVisible(!bl2);
                StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
                Dimension dimension = DimensionService.getInstance().getSize(StructuralSearchDialog.this.getDimensionServiceKey());
                if (dimension != null) {
                    StructuralSearchDialog.this.setSize(dimension.width, dimension.height);
                } else {
                    StructuralSearchDialog.this.pack();
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x2AE448B17485L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet(anAction.getShortcutSet(), (JComponent)this.getRootPane());
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.n = useLastConfiguration;
    }

    void setSearchPattern(Configuration config) {
        this.loadConfiguration(config);
        this.initiateValidation();
    }

    private EditorTextField a(String string) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (structuralSearchProfile != null);
        Document document = structuralSearchProfile.createDocument(this.k(), this.myFileType, this.myDialect, string);
        EditorTextField editorTextField = new EditorTextField(document, this.k(), this.myFileType, false, false){
            private static final long a = lb.a(8762384259408337213L, -1587609163804837526L, MethodHandles.lookup().lookupClass()).a(33834442846927L);

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                editorEx.setHorizontalScrollbarVisible(true);
                editorEx.setVerticalScrollbarVisible(true);
                StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                assert (structuralSearchProfile != null);
                TemplateEditorUtil.setHighlighter((Editor)editorEx, (TemplateContextType)structuralSearchProfile.getTemplateContextType());
                SubstitutionShortInfoHandler.install((Editor)editorEx, string -> StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(string, StructuralSearchDialog.this.myConfiguration)));
                editorEx.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
                Project project = this.getProject();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.getDocument());
                if (psiFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, false);
                }
                TextCompletionUtil.installCompletionHint((EditorEx)editorEx);
                editorEx.putUserData(STRUCTURAL_SEARCH, (Object)StructuralSearchDialog.this);
                editorEx.setEmbeddedIntoDialogWrapper(true);
                return editorEx;
            }

            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    3.a(0);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x2472BB3D679DL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "updateBorder"));
            }
        };
        editorTextField.setPreferredSize(new Dimension(850, 150));
        editorTextField.setMinimumSize(new Dimension(200, 50));
        editorTextField.addDocumentListener(new DocumentListener(){
            private static final long a = lb.a(3091898428150192472L, 4608062251647028267L, MethodHandles.lookup().lookupClass()).a(205164866297181L);

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.a(0);
                }
                StructuralSearchDialog.this.initiateValidation();
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0xA74445315D8L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$4", "documentChanged"));
            }
        });
        return editorTextField;
    }

    void initiateValidation() {
        if (this.k.isDisposed()) {
            return;
        }
        this.k.cancelAllRequests();
        this.k.addRequest(() -> {
            try {
                boolean bl2 = this.a();
                boolean bl3 = this.e();
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myFilterButtonEnabled = bl3;
                    this.a(this.myConfiguration.getMatchOptions());
                    this.getOKAction().setEnabled(bl2);
                }, ModalityState.stateForComponent((Component)this.getRootPane()));
            }
            catch (ProcessCanceledException processCanceledException) {
                throw processCanceledException;
            }
            catch (RuntimeException runtimeException) {
                Logger.getInstance(StructuralSearchDialog.class).error((Throwable)runtimeException);
            }
        }, 250);
    }

    private boolean e() {
        long l3 = s ^ 0x1C6E4B12168L;
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.k(), this.myConfiguration.getMatchOptions(), false);
            if (compiledPattern != null) {
                this.myFilterPanel.setCompiledPattern(compiledPattern);
                if (!this.myFilterPanel.isInitialized()) {
                    this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
                }
            }
            return compiledPattern != null;
        }
        catch (MalformedPatternException malformedPatternException) {
            return false;
        }
    }

    private void l() {
        FileType fileType;
        StructuralSearchProfile structuralSearchProfile;
        PsiFile psiFile = this.h.getFile();
        Editor editor = this.h.getEditor();
        if (editor != null && psiFile != null && (psiFile = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            psiFile = psiFile.getParent();
        }
        if (psiFile != null && (structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement((PsiElement)psiFile)) != null && (fileType = structuralSearchProfile.detectFileType((PsiElement)psiFile)) != null) {
            this.myFileType = fileType;
            return;
        }
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
    }

    public Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(USER_DEFINED, USER_DEFINED) : new ReplaceConfiguration(template);
        }
        return template == null ? new SearchConfiguration(USER_DEFINED, USER_DEFINED) : new SearchConfiguration(template);
    }

    private void b(String string) {
        this.a(string, this.mySearchCriteriaEdit);
        if (this.myReplace) {
            this.a(string, this.myReplaceCriteriaEdit);
        }
    }

    private void a(String string, EditorTextField editorTextField) {
        editorTextField.setText(string);
        editorTextField.selectAll();
        Project project = this.k();
        Document document = editorTextField.getDocument();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, new TextRange(0, document.getTextLength())));
    }

    private void i() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.h).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.h).startSearching();
        }
    }

    @NotNull
    String getDefaultTitle() {
        long l3 = s ^ 0x440B7D7CC147L;
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.a(0);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        long l3 = s ^ 0x4DFBA3D9B882L;
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.o = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchEditorPanel.getDivider().setOpaque(false);
        this.mySearchCriteriaEdit = this.a("");
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        this.mySearchEditorPanel.add("Center", (Component)this.mySearchCriteriaEdit);
        this.myReplacePanel = this.f();
        this.myReplacePanel.setVisible(this.myReplace);
        this.l = new ScopePanel(this.k());
        if (!this.i) {
            this.l.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.k()).getRecentDirectories());
            this.l.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)searchScope -> {
                if (searchScope == null) {
                    this.getOKAction().setEnabled(false);
                } else {
                    this.initiateValidation();
                }
            }));
        } else {
            this.l.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.k(), StructuralSearchUtil.getProfileByFileType(this.myFileType), this.getDisposable());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        JLabel jLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.p = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.p.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)string -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String string2 : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(string2).setPartOfSearchResults(string2.equals(string));
            }
        }));
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent((Component)this.mySearchEditorPanel).addComponent(this.myReplacePanel).addComponent(this.l).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.p), -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)this.mySearchEditorPanel).addGap(2).addComponent(this.myReplacePanel).addComponent(this.l, -2, -1, -2).addGap(16).addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent((Component)((Object)this.p), -2, -1, -2)));
        return jPanel;
    }

    private JComponent f() {
        long l3 = s ^ 0x3122E38C1EF1L;
        JLabel jLabel = new JLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.f = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.b = new JCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.a = new JCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myReplaceCriteriaEdit = this.a("");
        this.o.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 28, 28).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.f).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.b).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.a)).addComponent((Component)this.o));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.f).addComponent(this.b).addComponent(this.a)).addComponent((Component)this.o));
        return jPanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        FileType fileType32;
        long l3 = s ^ 0x6C140B0E32AAL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new AnAction(StructuralSearchDialog.j()){
            private static final long a = lb.a(2227227851492181879L, -9167123566170673381L, MethodHandles.lookup().lookupClass()).a(87757481807383L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                Object object;
                if (e10 == null) {
                    5.a(0);
                }
                if (!((object = e10.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.k()).getHistoryConfigurations()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<Configuration>(){
                    private static final long a = lb.a(5772794240329957347L, -8363572019243977965L, MethodHandles.lookup().lookupClass()).a(244141336267434L);

                    protected void customizeCellRenderer(@NotNull JList<? extends Configuration> list2, Configuration value, int index, boolean selected, boolean hasFocus) {
                        long l3 = a ^ 0x37E1B65BE898L;
                        if (list2 == null) {
                            1.a(0);
                        }
                        if (value instanceof ReplaceConfiguration) {
                            this.setIcon(AllIcons.Actions.Replace);
                            this.append(StringUtil.shortenTextWithEllipsis((String)value.getMatchOptions().getSearchPattern(), (int)49, (int)0, (boolean)true) + " \u21d2 " + StringUtil.shortenTextWithEllipsis((String)value.getReplaceOptions().getReplacement(), (int)49, (int)0, (boolean)true));
                        } else {
                            this.setIcon(AllIcons.Actions.Find);
                            this.append(StringUtil.shortenTextWithEllipsis((String)value.getMatchOptions().getSearchPattern(), (int)100, (int)0, (boolean)true));
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l3 = a ^ 0x4488722C9FAL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5$1", "customizeCellRenderer"));
                    }
                }).setItemChosenCallback(configuration -> StructuralSearchDialog.this.setSearchPattern((Configuration)configuration)).setSelectionMode(0).createPopup().showUnderneathOf((Component)object);
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x42E5B1C8673L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "actionPerformed"));
            }
        }});
        ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)defaultActionGroup, true);
        actionToolbarImpl.setLayoutPolicy(0);
        JLabel jLabel = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(jLabel, (Producer<? extends Configuration>)((Producer)() -> this.myConfiguration));
        this.myRecursive = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.myRecursive.setVisible(!this.myReplace);
        this.c = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        ArrayList<FileType> arrayList = new ArrayList<FileType>();
        for (FileType fileType32 : StructuralSearchUtil.getSuitableFileTypes()) {
            if (StructuralSearchUtil.getProfileByFileType(fileType32) == null) continue;
            arrayList.add(fileType32);
        }
        Collections.sort(arrayList, (fileType, fileType2) -> fileType.getName().compareToIgnoreCase(fileType2.getName()));
        this.l();
        this.myFileTypesComboBox = new FileTypeSelector(arrayList);
        this.myFileTypesComboBox.setMinimumAndPreferredWidth(200);
        this.myFileTypesComboBox.setSelectedItem(this.myFileType, this.myDialect, this.myContext);
        this.myFileTypesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e10) {
                if (e10.getStateChange() == 1) {
                    FileTypeInfo fileTypeInfo = StructuralSearchDialog.this.myFileTypesComboBox.getSelectedItem();
                    if (fileTypeInfo == null) {
                        return;
                    }
                    StructuralSearchDialog.this.myFileType = fileTypeInfo.getFileType();
                    StructuralSearchDialog.this.myDialect = fileTypeInfo.getDialect();
                    StructuralSearchDialog.this.myContext = fileTypeInfo.getContext();
                    StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                    assert (structuralSearchProfile != null);
                    Document document = structuralSearchProfile.createDocument(StructuralSearchDialog.this.k(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.mySearchCriteriaEdit.getText());
                    StructuralSearchDialog.this.mySearchCriteriaEdit.setNewDocumentAndFileType(StructuralSearchDialog.this.myFileType, document);
                    Document document2 = structuralSearchProfile.createDocument(StructuralSearchDialog.this.k(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myReplaceCriteriaEdit.getText());
                    StructuralSearchDialog.this.myReplaceCriteriaEdit.setNewDocumentAndFileType(StructuralSearchDialog.this.myFileType, document2);
                    StructuralSearchDialog.this.myFilterPanel.setProfile(structuralSearchProfile);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        JLabel jLabel2 = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        jLabel2.setLabelFor((Component)((Object)this.myFileTypesComboBox));
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup(new AnAction[]{new AnAction(SSRBundle.message("save.template.text.button", new Object[0])){
            private static final long a = lb.a(-2844549103928494053L, 3494393827682514138L, MethodHandles.lookup().lookupClass()).a(267238575480450L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    7.a(0);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.k()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x7124F037528AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7", "actionPerformed"));
            }
        }, new AnAction(SSRBundle.message("copy.existing.template.button", new Object[0])){
            private static final long a = lb.a(-3808519862110383341L, -8360326799425599429L, MethodHandles.lookup().lookupClass()).a(117786313668233L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog;
                if (e10 == null) {
                    8.a(0);
                }
                if (!(selectTemplateDialog = new SelectTemplateDialog(StructuralSearchDialog.this.k(), false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    StructuralSearchDialog.this.setSearchPattern(configurationArray[0]);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x2629C12D64FDL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8", "actionPerformed"));
            }
        }});
        defaultActionGroup2.setPopup(true);
        defaultActionGroup2.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        ToggleAction toggleAction = new ToggleAction(null, "View variable filters", AllIcons.General.Filter){
            private static final long a = lb.a(4497861337153690858L, 1701373196400802303L, MethodHandles.lookup().lookupClass()).a(73152513516784L);

            public boolean isSelected(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    9.a(0);
                }
                return StructuralSearchDialog.this.mySearchEditorPanel.getSecondComponent() != null;
            }

            public void setSelected(@NotNull AnActionEvent e10, boolean state) {
                if (e10 == null) {
                    9.a(1);
                }
                StructuralSearchDialog.this.mySearchEditorPanel.setSecondComponent(state ? StructuralSearchDialog.this.myFilterPanel.getComponent() : null);
            }

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    9.a(2);
                }
                e10.getPresentation().setEnabled(StructuralSearchDialog.this.myFilterButtonEnabled);
                super.update(e10);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l3 = a ^ 0x172514C3CBE9L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$9";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        fileType32 = new DefaultActionGroup(new AnAction[]{toggleAction, defaultActionGroup2});
        ActionToolbarImpl actionToolbarImpl2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)fileType32, true);
        actionToolbarImpl2.setLayoutPolicy(0);
        actionToolbarImpl2.setForceMinimumSize(true);
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHonorsVisibility(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)actionToolbarImpl, -2, -1, -2).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myRecursive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.c).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myFileTypesComboBox), 125, -1, -2).addComponent((Component)actionToolbarImpl2, -2, -1, -2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)actionToolbarImpl).addComponent(jLabel).addComponent(this.myRecursive).addComponent(this.c).addComponent(jLabel2).addComponent((Component)((Object)this.myFileTypesComboBox)).addComponent((Component)actionToolbarImpl2));
        return jPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        long l3 = s ^ 0x29AC11138B07L;
        if (this.i) {
            return null;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.e = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.e.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        jPanel.add((Component)this.e, "East");
        return jPanel;
    }

    private List<String> d() {
        long l3 = s ^ 0x237D01F5B79BL;
        ArrayList<String> arrayList = new ArrayList<String>(TemplateImplUtil.parseVariables((CharSequence)this.myConfiguration.getMatchOptions().getSearchPattern()).keySet());
        if (this.myReplace) {
            for (String string : TemplateImplUtil.parseVariables((CharSequence)this.myConfiguration.getReplaceOptions().getReplacement()).keySet()) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string + "$replacement");
            }
        }
        return arrayList;
    }

    private Project k() {
        return this.h.getProject();
    }

    public void show() {
        StructuralSearchPlugin.getInstance(this.k()).setDialogVisible(true);
        if (!this.n) {
            Object object;
            Editor editor = this.h.getEditor();
            boolean bl2 = false;
            if (editor != null && (object = editor.getSelectionModel()).hasSelection()) {
                this.b(object.getSelectedText());
                this.l.setScope(null);
                bl2 = true;
            }
            if (!bl2 && (object = ConfigurationManager.getInstance(this.k()).getMostRecentConfiguration()) != null) {
                this.loadConfiguration((Configuration)object);
            }
        }
        this.initiateValidation();
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    protected void doOKAction() {
        FindSettings findSettings;
        long l3 = s ^ 0x55BC1F1B3CECL;
        this.j = true;
        boolean bl2 = this.a();
        this.j = false;
        if (!bl2) {
            return;
        }
        this.k.cancelAllRequests();
        this.b();
        SearchScope searchScope = this.l.getScope();
        if (searchScope == null) {
            return;
        }
        super.doOKAction();
        if (this.i) {
            return;
        }
        if (searchScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            findSettings = (GlobalSearchScopesCore.DirectoryScope)searchScope;
            FindInProjectSettings.getInstance((Project)this.k()).addDirectory(findSettings.getDirectory().getPresentableUrl());
        }
        findSettings = FindSettings.getInstance();
        findSettings.setDefaultScopeName(searchScope.getDisplayName());
        findSettings.setShowResultsInSeparateView(this.e.isSelected());
        try {
            ConfigurationManager.getInstance(this.k()).addHistoryConfiguration(this.myConfiguration);
            this.i();
        }
        catch (MalformedPatternException malformedPatternException) {
            this.a(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    private void b() {
        long l3 = s ^ 0x7F3F672624D8L;
        List<String> list2 = this.d();
        list2.add("__context__");
        this.myConfiguration.getMatchOptions().retainVariableConstraints(list2);
    }

    public Configuration getConfiguration() {
        this.b();
        this.g();
        return this.myConfiguration;
    }

    private boolean a() {
        long l3 = s ^ 0xC053F0FC6A8L;
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        try {
            Matcher.validate(this.k(), matchOptions);
        }
        catch (MalformedPatternException malformedPatternException) {
            String string = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage() != null ? malformedPatternException.getMessage() : "");
            this.a(string, true, (JComponent)this.mySearchCriteriaEdit);
            return false;
        }
        catch (UnsupportedPatternException unsupportedPatternException) {
            this.a(SSRBundle.message("this.pattern.is.unsupported.message", unsupportedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return false;
        }
        catch (NoMatchFoundException noMatchFoundException) {
            this.a(noMatchFoundException.getMessage(), false, this.l);
            return false;
        }
        this.a(null, false, (JComponent)this.mySearchCriteriaEdit);
        if (this.myReplace) {
            try {
                Replacer.checkSupportedReplacementPattern(this.k(), this.myConfiguration.getReplaceOptions());
            }
            catch (UnsupportedPatternException unsupportedPatternException) {
                this.a(SSRBundle.message("unsupported.replacement.pattern.message", unsupportedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                return false;
            }
            catch (MalformedPatternException malformedPatternException) {
                this.a(SSRBundle.message("malformed.replacement.pattern.message", malformedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
                return false;
            }
        }
        this.a(null, false, (JComponent)this.myReplaceCriteriaEdit);
        return this.i || this.l.getScope() != null;
    }

    private void a(String string, boolean bl2, JComponent jComponent) {
        com.intellij.util.ui.UIUtil.invokeLaterIfNeeded(() -> {
            long l3 = s ^ 0x3A99D7871F63L;
            jComponent.putClientProperty("JComponent.outline", !bl2 || string == null ? null : "error");
            jComponent.repaint();
            if (string == null) {
                return;
            }
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(string, bl2 ? MessageType.ERROR : MessageType.WARNING, null).createBalloon();
            if (jComponent == this.mySearchCriteriaEdit) {
                balloon.show(new RelativePoint((Component)jComponent, new Point(jComponent.getWidth() / 2, jComponent.getHeight())), Balloon.Position.below);
            } else {
                balloon.show(new RelativePoint((Component)jComponent, new Point(jComponent.getWidth() / 2, 0)), Balloon.Position.above);
            }
            balloon.showInCenterOf(jComponent);
            Disposer.register((Disposable)this.myDisposable, (Disposable)balloon);
        });
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
    }

    private void a(MatchOptions matchOptions) {
        long l3 = s ^ 0x31B7065B6535L;
        ArrayList<String> arrayList = new ArrayList<String>(matchOptions.getVariableConstraintNames());
        arrayList.remove("__context__");
        arrayList.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.p.setItems(arrayList);
        if (arrayList.size() > 1) {
            this.p.setEnabled(true);
            for (String string : arrayList) {
                MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(string);
                if (matchVariableConstraint == null || !matchVariableConstraint.isPartOfSearchResults()) continue;
                this.p.setSelectedItem(string);
                break;
            }
        } else {
            this.p.setEnabled(false);
        }
    }

    public void loadConfiguration(Configuration configuration) {
        long l3 = s ^ 0x417C502C934BL;
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.a(matchOptions);
        SearchScope searchScope = matchOptions.getScope();
        if (searchScope != null) {
            this.l.setScope(searchScope);
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        this.c.setSelected(matchOptions.isCaseSensitiveMatch());
        this.myFileTypesComboBox.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor editor = this.mySearchCriteriaEdit.getEditor();
        if (editor != null) {
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (this.myReplace) {
            ReplaceOptions replaceOptions;
            if (configuration instanceof ReplaceConfiguration) {
                replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
                this.f.setSelected(replaceOptions.isToShortenFQN());
                this.b.setSelected(replaceOptions.isToReformatAccordingToStyle());
                this.a.setSelected(replaceOptions.isToUseStaticImport());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
                this.f.setSelected(propertiesComponent.getBoolean(m));
                this.b.setSelected(propertiesComponent.getBoolean(g));
                this.a.setSelected(propertiesComponent.getBoolean(d));
            }
            replaceOptions = this.myReplaceCriteriaEdit.getEditor();
            if (replaceOptions != null) {
                replaceOptions.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, this.myConfiguration);
            }
            this.myRecursive.setSelected(false);
        } else if (configuration instanceof ReplaceConfiguration) {
            this.myRecursive.setSelected(propertiesComponent.getBoolean(q));
        }
    }

    private void g() {
        Object object;
        long l3 = s ^ 0x1F89B0B12ADL;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.i && (object = this.l.getScope()) != null) {
            boolean bl2 = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(object.getDisplayName());
            matchOptions.setScope((SearchScope)(bl2 && !this.j ? GlobalSearchScope.projectScope((Project)this.k()) : object));
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myContext);
        matchOptions.setSearchPattern(this.mySearchCriteriaEdit.getDocument().getText());
        matchOptions.setCaseSensitiveMatch(this.c.isSelected());
        if (this.myReplace) {
            object = this.myConfiguration.getReplaceOptions();
            ((ReplaceOptions)object).setReplacement(this.myReplaceCriteriaEdit.getDocument().getText());
            ((ReplaceOptions)object).setToShortenFQN(this.f.isSelected());
            ((ReplaceOptions)object).setToReformatAccordingToStyle(this.b.isSelected());
            ((ReplaceOptions)object).setToUseStaticImport(this.a.isSelected());
        } else {
            matchOptions.setRecursiveSearch(this.myRecursive.isSelected());
        }
        object = PropertiesComponent.getInstance();
        if (this.myReplace) {
            object.setValue(m, this.f.isSelected());
            object.setValue(g, this.b.isSelected());
            object.setValue(d, this.a.isSelected());
        } else {
            object.setValue(q, this.myRecursive.isSelected());
            object.setValue(r, this.c.isSelected());
        }
    }

    @NotNull
    protected String getDimensionServiceKey() {
        long l3 = s ^ 0x13820E24EF4FL;
        String string = this.myReplace ? "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog" : "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
        if (string == null) {
            StructuralSearchDialog.a(1);
        }
        return string;
    }

    public void dispose() {
        StructuralSearchPlugin.getInstance(this.k()).setDialogVisible(false);
        this.k.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        super.dispose();
    }

    protected String getHelpId() {
        long l3 = s ^ 0x47CFF913E153L;
        return "find.structuredSearch";
    }

    private static Icon j() {
        long l3 = s ^ 0x2984AD8B9F63L;
        return (Icon)ObjectUtils.coalesce((Object)UIManager.getIcon("TextField.darcula.searchWithHistory.icon"), (Object)LafIconLookup.getIcon((String)"searchWithHistory"));
    }

    static {
        s = lb.a(-1612606856649679148L, -37474307628808840L, MethodHandles.lookup().lookupClass()).a(168942616290476L);
        long l3 = s ^ 0x7CD34C88FB8EL;
        STRUCTURAL_SEARCH = Key.create((String)"STRUCTURAL_SEARCH_AREA");
        USER_DEFINED = SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l3 = s ^ 0x486C05BD5294L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

