/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlActionHandler getHandler(@NotNull PsiFile file2) {
        if (file2 == null) {
            ValidateXmlAction.$$$reportNull$$$0(0);
        }
        ValidateXmlActionHandler handler2 = new ValidateXmlActionHandler(true);
        handler2.setErrorReporter(new StdErrorReporter(handler2, file2, () -> {
            if (file2 == null) {
                ValidateXmlAction.$$$reportNull$$$0(6);
            }
            this.doRunAction(file2);
        }));
        return handler2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            ValidateXmlAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext())) != null && psiFile.getVirtualFile() != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ValidateXmlAction.$$$reportNull$$$0(2);
        }
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            if (psiFile == null) {
                ValidateXmlAction.$$$reportNull$$$0(4);
            }
            Runnable action = () -> {
                if (psiFile == null) {
                    ValidateXmlAction.$$$reportNull$$$0(5);
                }
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, this.getCommandName(), null);
    }

    private String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text != null ? text : "";
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ValidateXmlAction.$$$reportNull$$$0(3);
        }
        super.update(event);
        Presentation presentation = event.getPresentation();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_FILE.getData(event.getDataContext());
        boolean visible = psiElement instanceof XmlFile;
        presentation.setVisible(visible);
        boolean enabled = psiElement instanceof XmlFile;
        if (enabled) {
            PsiFile containingFile = psiElement.getContainingFile();
            enabled = containingFile != null && containingFile.getVirtualFile() != null && (containingFile.getFileType() == StdFileTypes.XML || containingFile.getFileType() == StdFileTypes.XHTML) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/actions/validate/ValidateXmlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRunAction$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getHandler$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

