/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.awt.Component;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebugView
implements Disposable {
    private final SingleAlarm myClearAlarm = new SingleAlarm(() -> this.clear(), 100, this);
    private static final int VIEW_CLEAR_DELAY = 100;

    protected final void requestClear() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.clear();
        } else {
            this.myClearAlarm.cancelAndRequest();
        }
    }

    protected final void cancelClear() {
        this.myClearAlarm.cancel();
    }

    protected abstract void clear();

    public abstract void processSessionEvent(@NotNull SessionEvent var1, @NotNull XDebugSession var2);

    @Nullable
    protected static XDebugSession getSession(@NotNull EventObject e) {
        if (e == null) {
            XDebugView.$$$reportNull$$$0(0);
        }
        Component component = e.getSource() instanceof Component ? (Component)e.getSource() : null;
        return component == null ? null : XDebugView.getSession(component);
    }

    @Nullable
    public static XDebugSession getSession(@NotNull Component component) {
        if (component == null) {
            XDebugView.$$$reportNull$$$0(1);
        }
        return (XDebugSession)XDebugView.getData(XDebugSession.DATA_KEY, component);
    }

    @Nullable
    protected VirtualFile getCurrentFile(@NotNull Component component) {
        XSourcePosition position;
        XDebugSession session2;
        if (component == null) {
            XDebugView.$$$reportNull$$$0(2);
        }
        if ((session2 = XDebugView.getSession(component)) != null && (position = session2.getCurrentPosition()) != null) {
            return position.getFile();
        }
        return null;
    }

    @Nullable
    public static <T> T getData(DataKey<T> key, @NotNull Component component) {
        Object data;
        DataContext dataContext;
        ViewContext viewContext;
        ContentManager contentManager;
        if (component == null) {
            XDebugView.$$$reportNull$$$0(3);
        }
        ContentManager contentManager2 = contentManager = (viewContext = (ViewContext)ViewContext.CONTEXT_KEY.getData(dataContext = DataManager.getInstance().getDataContext(component))) == null ? null : viewContext.getContentManager();
        if (contentManager != null && (data = key.getData(DataManager.getInstance().getDataContext((Component)contentManager.getComponent()))) != null) {
            return (T)data;
        }
        return (T)key.getData(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebugView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSession";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SessionEvent {
        PAUSED,
        BEFORE_RESUME,
        RESUMED,
        STOPPED,
        FRAME_CHANGED,
        SETTINGS_CHANGED;

    }
}

