/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubjectBodySeparationInspection
extends BaseCommitMessageInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Blank line between subject and body" == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(0);
        }
        return "Blank line between subject and body";
    }

    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(1);
        }
        if (document == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(3);
        }
        ProblemDescriptor descriptor = document.getLineCount() > 1 ? SubjectBodySeparationInspection.checkRightMargin(file2, document, manager, isOnTheFly, 1, 0, "Missing blank line between subject and body", new LocalQuickFix[]{new AddBlankLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()}) : null;
        return descriptor != null ? (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{descriptor}) : null;
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(4);
        }
        if (document == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(5);
        }
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(6);
        }
        if (document == null) {
            SubjectBodySeparationInspection.$$$reportNull$$$0(7);
        }
        new AddBlankLineQuickFix().doApplyFix(project, document, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/SubjectBodySeparationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/SubjectBodySeparationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canReformat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class AddBlankLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected AddBlankLineQuickFix() {
            super("Add blank line");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            TextRange lineRange;
            int line;
            if (project == null) {
                AddBlankLineQuickFix.$$$reportNull$$$0(0);
            }
            if (document == null) {
                AddBlankLineQuickFix.$$$reportNull$$$0(1);
            }
            int n = line = descriptor != null && descriptor.getLineNumber() >= 0 ? descriptor.getLineNumber() : AddBlankLineQuickFix.getFirstLine(document);
            if (line >= 0 && !(lineRange = DocumentUtil.getLineTextRange(document, line)).isEmpty()) {
                document.insertString(lineRange.getStartOffset(), (CharSequence)"\n");
            }
        }

        private static int getFirstLine(@NotNull Document document) {
            if (document == null) {
                AddBlankLineQuickFix.$$$reportNull$$$0(2);
            }
            return document.getLineCount() > 1 ? 1 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/commit/SubjectBodySeparationInspection$AddBlankLineQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApplyFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

