/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.Navigatable;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceToTextFileExporter;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SlicePanel
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private final SliceTreeBuilder myBuilder;
    private final JTree myTree;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private UsagePreviewPanel myUsagePreviewPanel;
    private final Project myProject;
    private boolean isDisposed;
    private final ToolWindow myToolWindow;
    private final SliceLanguageSupportProvider myProvider;

    protected SlicePanel(final @NotNull Project project, boolean dataFlowToThis, @NotNull SliceNode rootNode, boolean splitByLeafExpressions, final @NotNull ToolWindow toolWindow) {
        if (project == null) {
            SlicePanel.$$$reportNull$$$0(0);
        }
        if (rootNode == null) {
            SlicePanel.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            SlicePanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return SlicePanel.this.isAutoScroll();
            }

            protected void setAutoScrollMode(boolean state) {
                SlicePanel.this.setAutoScroll(state);
            }
        };
        this.myProvider = rootNode.getProvider();
        this.myToolWindow = toolWindow;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){
            ToolWindowAnchor myAnchor;
            {
                this.myAnchor = toolWindow.getAnchor();
            }

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void stateChanged() {
                if (!project.isOpen()) {
                    return;
                }
                if (toolWindow.getAnchor() != this.myAnchor) {
                    this.myAnchor = SlicePanel.this.myToolWindow.getAnchor();
                    SlicePanel.this.layoutPanel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/slicer/SlicePanel$2", "toolWindowRegistered"));
            }
        });
        this.myTree = this.createTree();
        this.myBuilder = new SliceTreeBuilder(this.myTree, project, dataFlowToThis, rootNode, splitByLeafExpressions);
        this.myBuilder.setCanYieldUpdate(!ApplicationManager.getApplication().isUnitTestMode());
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.addSubtreeToUpdate((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), () -> {
            if (this.isDisposed || this.myBuilder.isDisposed() || this.myProject.isDisposed()) {
                return;
            }
            final SliceNode rootNode1 = this.myBuilder.getRootSliceNode();
            this.myBuilder.expand(rootNode1, new Runnable(){

                @Override
                public void run() {
                    if (SlicePanel.this.isDisposed || SlicePanel.this.myBuilder.isDisposed() || SlicePanel.this.myProject.isDisposed()) {
                        return;
                    }
                    SlicePanel.this.myBuilder.select(rootNode1.myCachedChildren.get(0));
                }
            });
            this.treeSelectionChanged();
        });
        this.layoutPanel();
    }

    private void layoutPanel() {
        if (this.myUsagePreviewPanel != null) {
            Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        }
        this.removeAll();
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        if (this.isPreview()) {
            pane.setBorder(IdeBorderFactory.createBorder((int)5));
            boolean vertical = this.myToolWindow.getAnchor() == ToolWindowAnchor.LEFT || this.myToolWindow.getAnchor() == ToolWindowAnchor.RIGHT;
            Splitter splitter = new Splitter(vertical, UsageViewSettings.getInstance().getPreviewUsagesSplitterProportion());
            splitter.setFirstComponent((JComponent)pane);
            this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
            this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder((int)1));
            Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
            splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
            this.add((Component)splitter, "Center");
        } else {
            pane.setBorder(IdeBorderFactory.createBorder((int)1));
            this.add((Component)pane, "Center");
        }
        this.add((Component)this.createToolbar().getComponent(), "West");
        this.myTree.getParent().setBackground(UIManager.getColor("Tree.background"));
        this.revalidate();
    }

    public void dispose() {
        if (this.myUsagePreviewPanel != null) {
            UsageViewSettings.getInstance().setPreviewUsagesSplitterProportion(((Splitter)this.myUsagePreviewPanel.getParent()).getProportion());
            this.myUsagePreviewPanel = null;
        }
        this.isDisposed = true;
        ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
    }

    @NotNull
    private JTree createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Tree tree = new Tree((TreeModel)new DefaultTreeModel(root));
        tree.setOpaque(false);
        tree.setToggleClickCount(-1);
        tree.setCellRenderer((TreeCellRenderer)new MultiLanguageTreeCellRenderer(this.myProvider.getRenderer()));
        UIUtil.setLineStyleAngled((JTree)tree);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setSelectionPath(new TreePath(root.getPath()));
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
        tree.getSelectionModel().addTreeSelectionListener(e -> this.treeSelectionChanged());
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    List navigatables = SlicePanel.this.getNavigatables();
                    if (navigatables.isEmpty()) {
                        return;
                    }
                    for (Navigatable navigatable : navigatables) {
                        if (navigatable instanceof AbstractTreeNode && ((AbstractTreeNode)navigatable).getValue() instanceof Usage) {
                            navigatable = (Usage)((AbstractTreeNode)navigatable).getValue();
                        }
                        if (!navigatable.canNavigateToSource()) continue;
                        navigatable.navigate(false);
                        if (!(navigatable instanceof Usage)) continue;
                        ((Usage)navigatable).highlightInEditor();
                    }
                    e.consume();
                }
            }
        });
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                SliceNode node = SlicePanel.fromPath(path);
                node.calculateDupNode();
            }
        });
        Tree tree2 = tree;
        if (tree2 == null) {
            SlicePanel.$$$reportNull$$$0(3);
        }
        return tree2;
    }

    private void treeSelectionChanged() {
        SwingUtilities.invokeLater(() -> {
            if (this.isDisposed) {
                return;
            }
            List<UsageInfo> infos = this.getSelectedUsageInfos();
            if (infos != null && this.myUsagePreviewPanel != null) {
                this.myUsagePreviewPanel.updateLayout(infos);
            }
        });
    }

    private static SliceNode fromPath(TreePath path) {
        DefaultMutableTreeNode node;
        Object userObject;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof SliceNode) {
            return (SliceNode)userObject;
        }
        return null;
    }

    @Nullable
    private List<UsageInfo> getSelectedUsageInfos() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (TreePath path : paths) {
            SliceNode sliceNode = SlicePanel.fromPath(path);
            if (sliceNode == null) continue;
            result2.add(((SliceUsage)((Object)sliceNode.getValue())).getUsageInfo());
        }
        if (result2.isEmpty()) {
            return null;
        }
        return result2;
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        List<Navigatable> navigatables;
        if (key == null) {
            SlicePanel.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            SlicePanel.$$$reportNull$$$0(5);
        }
        if (key == CommonDataKeys.NAVIGATABLE_ARRAY && !(navigatables = this.getNavigatables()).isEmpty()) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)navigatables.toArray(new Navigatable[0]));
        }
    }

    @NotNull
    private List<Navigatable> getNavigatables() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            List<Navigatable> list2 = Collections.emptyList();
            if (list2 == null) {
                SlicePanel.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
            Object userObject = node.getUserObject();
            if (userObject instanceof Navigatable) {
                navigatables.add((Navigatable)userObject);
                continue;
            }
            if (!(node instanceof Navigatable)) continue;
            navigatables.add((Navigatable)node);
        }
        ArrayList<Navigatable> arrayList = navigatables;
        if (arrayList == null) {
            SlicePanel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new MyRefreshAction(this.myTree));
        if (this.isToShowAutoScrollButton()) {
            actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        }
        if (this.isToShowPreviewButton()) {
            actionGroup.add((AnAction)new ToggleAction(UsageViewBundle.message((String)"preview.usages.action.text", (Object[])new Object[]{"usages"}), "preview", AllIcons.Actions.PreviewDetails){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return SlicePanel.this.isPreview();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    SlicePanel.this.setPreview(state);
                    SlicePanel.this.layoutPanel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/slicer/SlicePanel$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.myProvider.registerExtraPanelActions(actionGroup, this.myBuilder);
        actionGroup.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new SliceToTextFileExporter(this.myBuilder, UsageViewSettings.getInstance())));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TypeHierarchyViewToolbar", (ActionGroup)actionGroup, false);
        if (actionToolbar == null) {
            SlicePanel.$$$reportNull$$$0(8);
        }
        return actionToolbar;
    }

    public boolean isToShowAutoScrollButton() {
        return true;
    }

    public abstract boolean isAutoScroll();

    public abstract void setAutoScroll(boolean var1);

    public boolean isToShowPreviewButton() {
        return true;
    }

    public abstract boolean isPreview();

    public abstract void setPreview(boolean var1);

    protected void close() {
        ProgressIndicator progress = this.myBuilder.getUi().getProgress();
        if (progress != null) {
            progress.cancel();
        }
    }

    public SliceTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SlicePanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SlicePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyRefreshAction
    extends RefreshAction {
        private MyRefreshAction(JComponent tree) {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.registerShortcutOn(tree);
        }

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRefreshAction.$$$reportNull$$$0(0);
            }
            SliceNode rootNode = (SliceNode)SlicePanel.this.myBuilder.getRootNode().getUserObject();
            rootNode.setChanged();
            SlicePanel.this.myBuilder.addSubtreeToUpdate(SlicePanel.this.myBuilder.getRootNode());
        }

        @Override
        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                MyRefreshAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/slicer/SlicePanel$MyRefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MultiLanguageTreeCellRenderer
    implements TreeCellRenderer {
        @NotNull
        private final SliceUsageCellRendererBase rootRenderer;
        @NotNull
        private final Map<SliceLanguageSupportProvider, SliceUsageCellRendererBase> providersToRenderers;

        MultiLanguageTreeCellRenderer(@NotNull SliceUsageCellRendererBase rootRenderer) {
            if (rootRenderer == null) {
                MultiLanguageTreeCellRenderer.$$$reportNull$$$0(0);
            }
            this.providersToRenderers = new HashMap<SliceLanguageSupportProvider, SliceUsageCellRendererBase>();
            this.rootRenderer = rootRenderer;
            rootRenderer.setOpaque(false);
        }

        @NotNull
        private SliceUsageCellRendererBase getRenderer(Object value) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                SliceUsageCellRendererBase sliceUsageCellRendererBase = this.rootRenderer;
                if (sliceUsageCellRendererBase == null) {
                    MultiLanguageTreeCellRenderer.$$$reportNull$$$0(1);
                }
                return sliceUsageCellRendererBase;
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (!(userObject instanceof SliceNode)) {
                SliceUsageCellRendererBase sliceUsageCellRendererBase = this.rootRenderer;
                if (sliceUsageCellRendererBase == null) {
                    MultiLanguageTreeCellRenderer.$$$reportNull$$$0(2);
                }
                return sliceUsageCellRendererBase;
            }
            SliceLanguageSupportProvider provider = ((SliceNode)userObject).getProvider();
            if (provider == null) {
                SliceUsageCellRendererBase sliceUsageCellRendererBase = this.rootRenderer;
                if (sliceUsageCellRendererBase == null) {
                    MultiLanguageTreeCellRenderer.$$$reportNull$$$0(3);
                }
                return sliceUsageCellRendererBase;
            }
            SliceUsageCellRendererBase renderer = this.providersToRenderers.get(provider);
            if (renderer == null) {
                renderer = provider.getRenderer();
                renderer.setOpaque(false);
                this.providersToRenderers.put(provider, renderer);
            }
            SliceUsageCellRendererBase sliceUsageCellRendererBase = renderer;
            if (sliceUsageCellRendererBase == null) {
                MultiLanguageTreeCellRenderer.$$$reportNull$$$0(4);
            }
            return sliceUsageCellRendererBase;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            return this.getRenderer(value).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row2, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/slicer/SlicePanel$MultiLanguageTreeCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/slicer/SlicePanel$MultiLanguageTreeCellRenderer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

