/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class CredentialsManagerImpl
extends CredentialsManager {
    @Override
    public List<CredentialsType> getAllTypes() {
        ArrayList<CredentialsType> result2 = new ArrayList<CredentialsType>();
        result2.add(CredentialsType.SSH_HOST);
        result2.add(CredentialsType.VAGRANT);
        result2.add(CredentialsType.WEB_DEPLOYMENT);
        result2.addAll(this.getExTypes());
        return result2;
    }

    @Override
    public List<CredentialsTypeEx> getExTypes() {
        return Arrays.asList(CredentialsTypeEx.EP_NAME.getExtensions());
    }

    @Override
    public void loadCredentials(String interpreterPath, @Nullable Element element, RemoteSdkAdditionalData data) {
        for (CredentialsType type : this.getAllTypes()) {
            if (!type.hasPrefix(interpreterPath)) continue;
            Object credentials = type.createCredentials();
            type.getHandler(credentials).load(element);
            data.setCredentials(type.getCredentialsKey(), credentials);
            return;
        }
        UnknownCredentialsHolder credentials = CredentialsType.UNKNOWN.createCredentials();
        credentials.setInterpreterPath(interpreterPath);
        credentials.load(element);
        data.setCredentials(CredentialsType.UNKNOWN_CREDENTIALS, credentials);
    }
}

