/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckinHandlersManagerImpl
extends CheckinHandlersManager {
    private final List<BaseCheckinHandlerFactory> myRegisteredBeforeCheckinHandlers;
    private final MultiMap<VcsKey, VcsCheckinHandlerFactory> myVcsMap = new MultiMap();

    public CheckinHandlersManagerImpl() {
        this.myRegisteredBeforeCheckinHandlers = new ArrayList<BaseCheckinHandlerFactory>();
        ContainerUtil.addAll(this.myRegisteredBeforeCheckinHandlers, (Object[])CheckinHandlerFactory.EP_NAME.getExtensions());
        for (VcsCheckinHandlerFactory factory : (VcsCheckinHandlerFactory[])VcsCheckinHandlerFactory.EP_NAME.getExtensions()) {
            this.myVcsMap.putValue((Object)factory.getKey(), (Object)factory);
        }
    }

    public List<BaseCheckinHandlerFactory> getRegisteredCheckinHandlerFactories(AbstractVcs<?>[] allActiveVcss) {
        ArrayList<BaseCheckinHandlerFactory> list2 = new ArrayList<BaseCheckinHandlerFactory>(this.myRegisteredBeforeCheckinHandlers.size() + allActiveVcss.length);
        for (AbstractVcs<?> vcs : allActiveVcss) {
            Collection factories = this.myVcsMap.get((Object)vcs.getKeyInstanceMethod());
            if (factories.isEmpty()) continue;
            list2.addAll(factories);
        }
        list2.addAll(this.myRegisteredBeforeCheckinHandlers);
        return list2;
    }
}

