/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Field;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeInsightSettings", storages={@Storage(value="editor.codeinsight.xml")})
public class CodeInsightSettings
implements PersistentStateComponent<Element>,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.CodeInsightSettings");
    public boolean SHOW_EXTERNAL_ANNOTATIONS_INLINE = true;
    public boolean SHOW_INFERRED_ANNOTATIONS_INLINE = false;
    public boolean SHOW_METHOD_CHAIN_TYPES_INLINE = true;
    public boolean SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    public boolean AUTO_POPUP_PARAMETER_INFO = true;
    public int PARAMETER_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_JAVADOC_INFO;
    public int JAVADOC_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_COMPLETION_LOOKUP = true;
    public int COMPLETION_CASE_SENSITIVE = 3;
    public static final int ALL = 1;
    public static final int NONE = 2;
    public static final int FIRST_LETTER = 3;
    public boolean SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    public boolean AUTOCOMPLETE_ON_CODE_COMPLETION = true;
    public boolean AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = true;
    @Deprecated
    public boolean AUTOCOMPLETE_COMMON_PREFIX = true;
    public boolean SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO;
    public boolean SHOW_SOURCE_INFERRED_ANNOTATIONS = true;
    @OptionTag(value="SMART_BACKSPACE")
    private int SMART_BACKSPACE = SmartBackspaceMode.AUTOINDENT.ordinal();
    public boolean SMART_INDENT_ON_ENTER = true;
    public boolean INSERT_BRACE_ON_ENTER = true;
    public boolean INSERT_SCRIPTLET_END_ON_ENTER = true;
    public boolean JAVADOC_STUB_ON_ENTER = true;
    public boolean SMART_END_ACTION = true;
    public boolean JAVADOC_GENERATE_CLOSING_TAG = true;
    public boolean SURROUND_SELECTION_ON_QUOTE_TYPED;
    public boolean AUTOINSERT_PAIR_BRACKET = true;
    public boolean AUTOINSERT_PAIR_QUOTE = true;
    public boolean REFORMAT_BLOCK_ON_RBRACE = true;
    public int REFORMAT_ON_PASTE = 3;
    public static final int NO_REFORMAT = 1;
    public static final int INDENT_BLOCK = 2;
    public static final int INDENT_EACH_LINE = 3;
    public static final int REFORMAT_BLOCK = 4;
    public boolean INDENT_TO_CARET_ON_PASTE;
    public int ADD_IMPORTS_ON_PASTE = 3;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ASK = 3;
    public boolean HIGHLIGHT_BRACES = true;
    public boolean HIGHLIGHT_SCOPE;
    public boolean USE_INSTANCEOF_ON_EQUALS_PARAMETER;
    public boolean USE_ACCESSORS_IN_EQUALS_HASHCODE;
    public boolean HIGHLIGHT_IDENTIFIER_UNDER_CARET = true;
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean ADD_MEMBER_IMPORTS_ON_THE_FLY = true;
    public boolean JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean TAB_EXITS_BRACKETS_AND_QUOTES;
    @Property(surroundWithTag=false)
    @XCollection(elementName="EXCLUDED_PACKAGE", valueAttributeName="NAME")
    public String[] EXCLUDED_PACKAGES = ArrayUtil.EMPTY_STRING_ARRAY;

    public static CodeInsightSettings getInstance() {
        return (CodeInsightSettings)ServiceManager.getService(CodeInsightSettings.class);
    }

    public CodeInsightSettings() {
        Application application = ApplicationManager.getApplication();
        if (Registry.is((String)"java.completion.argument.hints") || application != null && application.isInternal() && !application.isUnitTestMode() && Registry.is((String)"java.completion.argument.hints.internal")) {
            this.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION = true;
            Registry.get((String)"java.completion.argument.hints").setValue(false);
            Registry.get((String)"java.completion.argument.hints.internal").setValue(false);
        }
    }

    @Nullable
    public CodeInsightSettings clone() {
        try {
            return (CodeInsightSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Transient
    @NotNull
    public SmartBackspaceMode getBackspaceMode() {
        SmartBackspaceMode[] values = SmartBackspaceMode.values();
        SmartBackspaceMode smartBackspaceMode = this.SMART_BACKSPACE >= 0 && this.SMART_BACKSPACE < values.length ? values[this.SMART_BACKSPACE] : SmartBackspaceMode.OFF;
        if (smartBackspaceMode == null) {
            CodeInsightSettings.$$$reportNull$$$0(0);
        }
        return smartBackspaceMode;
    }

    @Transient
    public void setBackspaceMode(@NotNull SmartBackspaceMode mode) {
        if (mode == null) {
            CodeInsightSettings.$$$reportNull$$$0(1);
        }
        this.SMART_BACKSPACE = mode.ordinal();
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeInsightSettings.$$$reportNull$$$0(2);
        }
        this.setDefaults();
        try {
            XmlSerializer.deserializeInto((Object)this, (Element)state);
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    private void setDefaults() {
        try {
            ReflectionUtil.copyFields((Field[])CodeInsightSettings.class.getDeclaredFields(), (Object)new CodeInsightSettings(), (Object)this, (DifferenceFilter)new DifferenceFilter<Object>(null, null){

                public boolean isAccept(@NotNull Field field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !field.getName().equals("EXCLUDED_PACKAGES");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/CodeInsightSettings$1", "isAccept"));
                }
            });
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        this.EXCLUDED_PACKAGES = ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public Element getState() {
        Element element = new Element("state");
        this.writeExternal(element);
        return element;
    }

    public void writeExternal(Element element) {
        try {
            XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackspaceMode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBackspaceMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

