/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.smarty.SmartyLanguage;
import com.jetbrains.smarty.lang.SmartyElementTypes;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmartyFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private static final THashSet<Language> ourRelevantLanguages = new THashSet(Arrays.asList(new Language[]{SmartyLanguage.INSTANCE, StdFileTypes.HTML.getLanguage()}));

    public SmartyFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
        Language language = SmartyFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        this.myTemplateDataLanguage = language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.INSTANCE.substituteLanguage(language, virtualFile, manager.getProject());
    }

    public SmartyFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
    }

    @NotNull
    public Language getBaseLanguage() {
        SmartyLanguage smartyLanguage = SmartyLanguage.INSTANCE;
        if (smartyLanguage == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(0);
        }
        return smartyLanguage;
    }

    @NotNull
    protected SmartyFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(1);
        }
        SmartyFileViewProvider smartyFileViewProvider = new SmartyFileViewProvider((PsiManager)this.getManager(), fileCopy, false, this.myTemplateDataLanguage);
        if (smartyFileViewProvider == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(2);
        }
        return smartyFileViewProvider;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    public static Language getTemplateDataLanguage(VirtualFile virtualFile, Project project) {
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile);
        return language == null ? StdFileTypes.HTML.getLanguage() : language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        LinkedHashSet<Language> linkedHashSet = new LinkedHashSet<Language>(Arrays.asList(new Language[]{SmartyLanguage.INSTANCE, this.getTemplateDataLanguage()}));
        if (linkedHashSet == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            SmartyFileViewProvider.$$$reportNull$$$0(5);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)SmartyElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/SmartyFileViewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/SmartyFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

