/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.ui.PhpConfigurableItem;
import com.jetbrains.php.ui.PhpConfigurableWithDescription;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNamedCloneableItemsListEditor<T>
extends MasterDetailsComponent {
    private static final String DEFAULT_NAME = "Unnamed";
    private final Namer<? super T> myNamer;
    @NotNull
    private final NotNullFactory<? extends T> myFactory;
    @NotNull
    private final Cloner<T> myCloner;
    @NotNull
    private final ItemModelHandler<? super T> myItemModelHandler;
    @NotNull
    private final ItemsProvider<? extends T> myProvider;
    @NotNull
    private final ItemsConsumer<T> myConsumer;
    @NotNull
    private final ConfigurableFactory<? super T> myConfigurableFactory;
    @Nullable
    private final String myInitialItemName;
    @NotNull
    private final List<T> myOriginalItems;
    @NotNull
    private final List<T> myCloneItems;
    @NotNull
    private final Map<T, T> myCloneOriginalMap;
    @NotNull
    private String mySubjectDisplayName;
    @Nullable
    protected T myLastSelectedItem;
    private boolean myShowIcons;

    protected PhpNamedCloneableItemsListEditor(@NotNull Namer<? super T> namer, @NotNull NotNullFactory<? extends T> factory, @NotNull Cloner<T> cloner, @NotNull ItemsProvider<? extends T> provider, @NotNull ItemsConsumer<T> consumer, @NotNull ConfigurableFactory<? super T> configurableFactory, @NotNull ItemModelHandler<? super T> itemModelHandler, @Nullable String initialItemName) {
        if (namer == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(1);
        }
        if (cloner == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(4);
        }
        if (configurableFactory == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(5);
        }
        if (itemModelHandler == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(6);
        }
        this(namer, factory, cloner, provider, consumer, configurableFactory, itemModelHandler, initialItemName, true);
    }

    protected PhpNamedCloneableItemsListEditor(@NotNull Namer<? super T> namer, @NotNull NotNullFactory<? extends T> factory, @NotNull Cloner<T> cloner, @NotNull ItemsProvider<? extends T> provider, @NotNull ItemsConsumer<T> consumer, @NotNull ConfigurableFactory<? super T> configurableFactory, @NotNull ItemModelHandler<? super T> itemModelHandler, @Nullable String initialItemName, boolean initInConstructor) {
        if (namer == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(7);
        }
        if (factory == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(8);
        }
        if (cloner == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(11);
        }
        if (configurableFactory == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(12);
        }
        if (itemModelHandler == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(13);
        }
        this.myOriginalItems = new ArrayList<T>();
        this.myCloneItems = new ArrayList<T>();
        this.myCloneOriginalMap = new HashMap<T, T>();
        this.mySubjectDisplayName = "item";
        this.myNamer = namer;
        this.myFactory = factory;
        this.myCloner = cloner;
        this.myProvider = provider;
        this.myConsumer = consumer;
        this.myConfigurableFactory = configurableFactory;
        this.myItemModelHandler = itemModelHandler;
        this.myInitialItemName = initialItemName;
        this.myShowIcons = false;
        if (initInConstructor) {
            this.initTree();
        }
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    @NotNull
    public final String getSubjectDisplayName() {
        String string = this.mySubjectDisplayName;
        if (string == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected final void setSubjectDisplayName(@NotNull String subjectDisplayName) {
        if (subjectDisplayName == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(15);
        }
        this.mySubjectDisplayName = subjectDisplayName;
    }

    @Nullable
    protected T findItemByName(@Nullable String name) {
        if (name != null) {
            for (T item : this.myCloneItems) {
                if (!Comparing.equal((String)name, (String)this.myNamer.getName(item))) continue;
                return item;
            }
        }
        return null;
    }

    public List<T> getItems() {
        return this.myCloneItems;
    }

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(this.createAddAction());
        result.add(this.createDeleteAction());
        if (this.isCopyAvailable()) {
            result.add(this.createCopyAction());
        }
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    protected AnAction createDeleteAction() {
        return new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, PhpNamedCloneableItemsListEditor.forAll(o -> this.canDelete(((MasterDetailsComponent.MyNode)o).getConfigurable().getEditableObject())));
    }

    protected boolean canDelete(T item) {
        return true;
    }

    protected AnAction createAddAction() {
        return new AddAction();
    }

    protected AnAction createCopyAction() {
        return new CopyAction();
    }

    protected boolean isCopyAvailable() {
        return true;
    }

    private void addNewNode(T item) {
        this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new MyItemConfigurable(item)), this.myRoot);
        this.myCloneItems.add(item);
    }

    protected void onItemDeleted(Object item) {
        this.myCloneItems.remove(item);
    }

    protected void setDisplayName(T item, String newName) {
        this.myNamer.setName(item, newName);
    }

    @Nullable
    protected UnnamedConfigurable getItemConfigurable(T item) {
        Ref result = new Ref();
        TreeUtil.traverse((TreeNode)((TreeNode)this.myTree.getModel().getRoot()), node -> {
            NamedConfigurable configurable = (NamedConfigurable)((DefaultMutableTreeNode)node).getUserObject();
            if (configurable.getEditableObject() == item) {
                result.set((Object)((MyItemConfigurable)configurable).myConfigurable);
                return false;
            }
            return true;
        });
        return (UnnamedConfigurable)result.get();
    }

    @NotNull
    protected final List<UnnamedConfigurable> getItemConfigurables() {
        ArrayList<UnnamedConfigurable> configurables = new ArrayList<UnnamedConfigurable>();
        TreeUtil.traverse((TreeNode)((TreeNode)this.myTree.getModel().getRoot()), node -> {
            NamedConfigurable configurable;
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof NamedConfigurable && (configurable = (NamedConfigurable)userObject) instanceof MyItemConfigurable) {
                MyItemConfigurable configurable1 = (MyItemConfigurable)configurable;
                configurables.add(configurable1.myConfigurable);
            }
            return true;
        });
        ArrayList<UnnamedConfigurable> arrayList = configurables;
        if (arrayList == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public void setShowIcons(boolean showIcons) {
        this.myShowIcons = showIcons;
    }

    protected void initTree() {
        super.initTree();
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MasterDetailsComponent.MyNode) {
                    String description;
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
                    this.setIcon(node.getIcon(expanded));
                    Font font = UIUtil.getTreeFont();
                    if (node.isDisplayInBold()) {
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(font.deriveFont(0));
                    }
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    NamedConfigurable configurable = node.getConfigurable();
                    if (configurable instanceof MyItemConfigurable && StringUtil.isNotEmpty((String)(description = ((MyItemConfigurable)configurable).getNodeDescription()))) {
                        this.append(" ");
                        this.append(description, SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
    }

    public boolean isModified() {
        if (this.myOriginalItems.size() != this.myCloneItems.size()) {
            return true;
        }
        for (int i = 0; i < this.myCloneItems.size(); ++i) {
            T o1 = this.myCloneItems.get(i);
            T o2 = this.myOriginalItems.get(i);
            if (StringUtil.notNullize((String)this.myNamer.getName(o1)).equals(StringUtil.notNullize((String)this.myNamer.getName(o2)))) continue;
            return true;
        }
        return super.isModified();
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        this.myOriginalItems.clear();
        this.myOriginalItems.addAll(this.myProvider.getItems());
        this.myCloneItems.clear();
        this.myCloneOriginalMap.clear();
        for (T originalItem : this.myOriginalItems) {
            T cloneItem = this.myCloner.cloneOf(originalItem);
            this.myCloneOriginalMap.put(cloneItem, originalItem);
            this.addNewNode(cloneItem);
        }
        this.myState.setLastEditedConfigurable(this.myInitialItemName);
        super.reset();
    }

    public final void apply() throws ConfigurationException {
        this.validate();
        super.apply();
        for (T item : this.myCloneItems) {
            String name = this.myNamer.getName(item);
            if (!StringUtil.isEmptyOrSpaces((String)name)) continue;
            throw new ConfigurationException(PhpBundle.message("validation.value.is.not.specified.or.invalid", this.getSubjectDisplayName() + " name"));
        }
        for (T clonedItem : this.myCloneItems) {
            if (this.myCloneOriginalMap.containsKey(clonedItem)) {
                this.myItemModelHandler.onItemChanged(this.myCloneOriginalMap.get(clonedItem), clonedItem);
                continue;
            }
            this.myItemModelHandler.onItemAdded(clonedItem);
        }
        for (T clonedItem : this.myCloneOriginalMap.keySet()) {
            if (this.myCloneItems.contains(clonedItem)) continue;
            this.myItemModelHandler.onItemDeleted(this.myCloneOriginalMap.get(clonedItem));
        }
        this.myOriginalItems.clear();
        this.myCloneOriginalMap.clear();
        for (T cloneItem : this.myCloneItems) {
            T cloneOfCloneItem = this.myCloner.cloneOf(cloneItem);
            this.myCloneOriginalMap.put(cloneItem, cloneOfCloneItem);
            this.myOriginalItems.add(cloneOfCloneItem);
        }
        this.myConsumer.applyItems(this.myOriginalItems);
        this.onApply();
    }

    protected void validate() throws ConfigurationException {
    }

    protected void onApply() {
    }

    @Nullable
    protected T getSelectedItem() {
        return (T)this.getSelectedObject();
    }

    @NotNull
    public final T createItem() {
        Object object = this.myFactory.create();
        if (object == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(18);
        }
        return (T)object;
    }

    @NotNull
    protected T cloneItem(T item) {
        T t = this.myCloner.cloneOf(item);
        if (t == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(19);
        }
        return t;
    }

    @NotNull
    protected String suggestName(T item) {
        if (DEFAULT_NAME == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(20);
        }
        return DEFAULT_NAME;
    }

    @NotNull
    public String suggestUniqueName(T item) {
        String string = this.suggestUniqueName(this.suggestName(item));
        if (string == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    protected String suggestUniqueName(@Nullable String input) {
        String base;
        String newName = base = StringUtil.notNullize((String)input);
        int counter = 1;
        while (this.findItemByName(newName) != null) {
            newName = base + " (" + counter++ + ")";
        }
        String string = newName;
        if (string == null) {
            PhpNamedCloneableItemsListEditor.$$$reportNull$$$0(22);
        }
        return string;
    }

    protected void onItemCreated(T newItem) {
        this.myNamer.setName(newItem, this.suggestUniqueName(newItem));
        this.addNewNode(newItem);
        this.selectNodeInTree(newItem);
    }

    public void disposeUIResources() {
        this.myLastSelectedItem = this.getSelectedItem();
        super.disposeUIResources();
    }

    @Nullable
    public String getLastSelectedItemName() {
        return this.myLastSelectedItem != null ? this.myNamer.getName(this.myLastSelectedItem) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloner";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurableFactory";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemModelHandler";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpNamedCloneableItemsListEditor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subjectDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpNamedCloneableItemsListEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubjectDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemConfigurables";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneItem";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSubjectDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CopyAction
    extends DumbAwareAction {
        public CopyAction() {
            super("Copy", "Copy", PlatformIcons.COPY_ICON);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), (JComponent)PhpNamedCloneableItemsListEditor.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            PhpNamedCloneableItemsListEditor.this.onItemCreated(PhpNamedCloneableItemsListEditor.this.cloneItem(PhpNamedCloneableItemsListEditor.this.getSelectedItem()));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(PhpNamedCloneableItemsListEditor.this.getSelectedItem() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/ui/PhpNamedCloneableItemsListEditor$CopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class AddAction
    extends DumbAwareAction {
        public AddAction() {
            super("Add", "Add", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)PhpNamedCloneableItemsListEditor.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            PhpNamedCloneableItemsListEditor.this.onItemCreated(PhpNamedCloneableItemsListEditor.this.createItem());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/ui/PhpNamedCloneableItemsListEditor$AddAction", "actionPerformed"));
        }
    }

    protected class MyItemConfigurable
    extends NamedConfigurable {
        private final T myItem;
        private final UnnamedConfigurable myConfigurable;

        public MyItemConfigurable(T item) {
            super(PhpNamedCloneableItemsListEditor.this.myNamer.canRename(item), PhpNamedCloneableItemsListEditor.this.TREE_UPDATER);
            this.myItem = item;
            this.myConfigurable = PhpNamedCloneableItemsListEditor.this.myConfigurableFactory.createConfigurable(item);
        }

        public void setDisplayName(String name) {
            PhpNamedCloneableItemsListEditor.this.setDisplayName(this.myItem, name);
        }

        public Object getEditableObject() {
            return this.myItem;
        }

        public String getBannerSlogan() {
            return PhpNamedCloneableItemsListEditor.this.myNamer.getName(this.myItem);
        }

        public JComponent createOptionsPanel() {
            return this.myConfigurable.createComponent();
        }

        public String getDisplayName() {
            return StringUtil.notNullize((String)PhpNamedCloneableItemsListEditor.this.myNamer.getName(this.myItem));
        }

        public Icon getIcon(boolean expanded) {
            if (PhpNamedCloneableItemsListEditor.this.myShowIcons && this.myConfigurable instanceof Iconable) {
                return ((Iconable)this.myConfigurable).getIcon(0);
            }
            return null;
        }

        @Nullable
        public String getNodeDescription() {
            if (this.myConfigurable instanceof PhpConfigurableWithDescription) {
                return ((PhpConfigurableWithDescription)this.myConfigurable).getDescription();
            }
            return null;
        }

        @Nullable
        protected JComponent createTopRightComponent() {
            if (this.myConfigurable instanceof PhpConfigurableItem) {
                return ((PhpConfigurableItem)this.myConfigurable).createTopRightComponent();
            }
            return super.createTopRightComponent();
        }

        public String getHelpTopic() {
            if (this.myConfigurable instanceof Configurable) {
                return ((Configurable)this.myConfigurable).getHelpTopic();
            }
            return null;
        }

        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        public void reset() {
            this.myConfigurable.reset();
        }

        public void disposeUIResources() {
            this.myConfigurable.disposeUIResources();
        }
    }

    public static class DefaultItemModelHandler<T>
    implements ItemModelHandler<T> {
        @Override
        public void onItemChanged(@NotNull T oldItem, @NotNull T newItem) {
            if (oldItem == null) {
                DefaultItemModelHandler.$$$reportNull$$$0(0);
            }
            if (newItem == null) {
                DefaultItemModelHandler.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void onItemAdded(@NotNull T item) {
            if (item == null) {
                DefaultItemModelHandler.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void onItemDeleted(@NotNull T item) {
            if (item == null) {
                DefaultItemModelHandler.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newItem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/ui/PhpNamedCloneableItemsListEditor$DefaultItemModelHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onItemChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onItemAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onItemDeleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ItemModelHandler<T> {
        public void onItemChanged(@NotNull T var1, @NotNull T var2);

        public void onItemAdded(@NotNull T var1);

        public void onItemDeleted(@NotNull T var1);
    }

    public static interface ConfigurableFactory<T> {
        @NotNull
        public UnnamedConfigurable createConfigurable(@NotNull T var1);
    }

    public static interface ItemsConsumer<T> {
        public void applyItems(@NotNull List<T> var1);
    }

    public static interface ItemsProvider<T> {
        @NotNull
        public List<T> getItems();
    }

    public static interface Cloner<T> {
        @NotNull
        public T cloneOf(@NotNull T var1);
    }
}

