/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLanguageLevelRuntimeUsagesCollector
extends ProjectUsagesCollector {
    private static final String GROUP_ID = "statistics.php.language.level.vs.interpreter";
    private static final String BOTH = "both-";
    private static final String DIFFERENT = "different";
    private static final String NOT_INSTALLED = "interpreter-not-installed";

    @NotNull
    public String getGroupId() {
        if (GROUP_ID == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(0);
        }
        return GROUP_ID;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        PhpProjectConfigurationFacade manager;
        if (project == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(1);
        }
        if (!project.isDefault() && (manager = PhpProjectConfigurationFacade.getInstance(project)) != null) {
            String name = this.getUsageName(project, manager);
            Set set = ContainerUtil.set((Object[])new UsageDescriptor[]{new UsageDescriptor(name, 1)});
            if (set == null) {
                PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public String getUsageName(@NotNull Project project, PhpProjectConfigurationFacade manager) {
        PhpLanguageLevel runtime;
        if (project == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(4);
        }
        if ((runtime = PhpLanguageLevelRuntimeUsagesCollector.getRuntimeVersion(project, manager)) == null) {
            if (NOT_INSTALLED == null) {
                PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(5);
            }
            return NOT_INSTALLED;
        }
        PhpLanguageLevel level = manager.getLanguageLevel();
        if (runtime.equals((Object)level)) {
            String string = BOTH + level.getPresentableName();
            if (string == null) {
                PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (DIFFERENT == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(7);
        }
        return DIFFERENT;
    }

    @Nullable
    private static PhpLanguageLevel getRuntimeVersion(@Nullable Project project, @NotNull PhpProjectConfigurationFacade manager) {
        PhpInfo info;
        PhpInterpreter interpreter;
        if (manager == null) {
            PhpLanguageLevelRuntimeUsagesCollector.$$$reportNull$$$0(8);
        }
        if ((interpreter = manager.getInterpreter()) != null && (info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName())) != null) {
            return PhpLanguageLevel.parse(info.getShortVersion());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpLanguageLevelRuntimeUsagesCollector";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpLanguageLevelRuntimeUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUsageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

