/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpFunctionStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionImpl
extends PhpNamedElementImpl<PhpNamedStub>
implements Function,
StubBasedPsiElement<NamedStub> {
    private PhpScope myScope;

    public FunctionImpl(ASTNode node) {
        super(node);
    }

    protected FunctionImpl(PhpNamedStub stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            FunctionImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Override
    public PhpDocComment getDocComment() {
        PhpDocComment comment = null;
        if (this.isClosure()) {
            PsiElement parent = this.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && ((parent = parent.getParent()) instanceof AssignmentExpression || parent instanceof PhpReturn) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && (parent = parent.getParent()) instanceof Statement) {
                comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)((Statement)parent));
            }
            if (comment != null) {
                comment.putUserData(PhpDocComment.OWNER_KEY, (Object)this);
            }
            return comment;
        }
        return super.getDocComment();
    }

    public FunctionImpl(PhpFunctionStub stub) {
        super(stub, PhpStubElementTypes.FUNCTION);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFunctionPresentation(this);
    }

    @NotNull
    public Parameter[] getParameters() {
        if (this.getGreenStub() != null) {
            Parameter[] parameterArray = (Parameter[])this.getStubOrPsiChildren(PhpStubElementTypes.PARAMETER, Parameter.ARRAY_FACTORY);
            if (parameterArray == null) {
                FunctionImpl.$$$reportNull$$$0(1);
            }
            return parameterArray;
        }
        ParameterList element = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        if (element == null) {
            if (Parameter.EMPTY_ARRAY == null) {
                FunctionImpl.$$$reportNull$$$0(2);
            }
            return Parameter.EMPTY_ARRAY;
        }
        List<Parameter> childrenOfType = PhpPsiUtil.getChildren((PsiElement)element, (Condition<? super PsiElement>)Parameter.INSTANCEOF);
        Parameter[] parameterArray = childrenOfType.isEmpty() ? Parameter.EMPTY_ARRAY : childrenOfType.toArray(Parameter.EMPTY_ARRAY);
        if (parameterArray == null) {
            FunctionImpl.$$$reportNull$$$0(3);
        }
        return parameterArray;
    }

    public boolean hasRefParams() {
        Parameter parameter;
        Parameter[] parameters;
        boolean hasRefParams = false;
        Parameter[] parameterArray = parameters = this.getParameters();
        int n = parameterArray.length;
        for (int i = 0; i < n && !(hasRefParams = (parameter = parameterArray[i]).isPassByRef()); ++i) {
        }
        return hasRefParams;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FunctionImpl.$$$reportNull$$$0(4);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode node = constantReference.getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            FunctionImpl.$$$reportNull$$$0(5);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpFunction((Function)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.FUNCTION;
    }

    public boolean isClosure() {
        return this.getName().length() == 0;
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            FunctionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        type.add(this.getDeclaredType());
        if (!interactive) {
            type.add(this.getDocType());
        }
        if (!type.isEmpty()) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        PhpType phpType = this.getInferredType(interactive);
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDeclaredType() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(10);
            }
            return phpType;
        }
        PhpReturnType returnTypeElement = this.getReturnType();
        if (returnTypeElement != null) {
            PhpType phpType = returnTypeElement.getType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDocType() {
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null) {
            PhpDocReturnTag returnTag = docComment.getReturnTag();
            PhpType phpType = new PhpType().add((PsiElement)returnTag);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @NotNull
    public PhpType getInferredType() {
        PhpType phpType = this.getInferredType(true);
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(15);
        }
        return phpType;
    }

    @NotNull
    private PhpType getInferredType(boolean interactive) {
        PhpType type = new PhpType();
        if (this instanceof Method && ((Method)this).isAbstract()) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(16);
            }
            return phpType;
        }
        int returnCount = 0;
        if ((returnCount += FunctionImpl.scanTree((PsiElement)this, type, false, true, 20, interactive)) == 0) {
            returnCount += FunctionImpl.scanTree((PsiElement)this, type, true, true, 20, interactive);
        }
        if (interactive || returnCount == 0) {
            returnCount += FunctionImpl.scanTree((PsiElement)this, type, false, false, 30, interactive);
        }
        if (returnCount == 0 && type.isEmpty()) {
            type.add(PhpType.VOID);
        }
        if (type.isEmpty()) {
            type.add(PhpType.MIXED);
        }
        PhpType phpType = type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    @Nullable
    public PhpReturnType getReturnType() {
        return (PhpReturnType)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpReturnType.INSTANCEOF);
    }

    private static void visitReturn(PhpReturn returnStatement, PhpType type) {
        PsiElement value = returnStatement.getArgument();
        if (value != null) {
            if (PhpLangUtil.isThisReference(value)) {
                type.add("$this");
            } else if (value instanceof Variable) {
                Collection resolve = ((Variable)value).resolveLocal();
                if (resolve.size() > 0) {
                    int count = 0;
                    for (PhpNamedElement element : resolve) {
                        type.add(element.getType());
                        if (count++ <= 5) continue;
                        break;
                    }
                }
            } else {
                type.add(value);
            }
        } else {
            type.add(PhpType.VOID);
        }
    }

    private static int scanTree(PsiElement root, PhpType type, boolean reverseOrder, boolean depthFirst, int statementLimit, boolean interactive) {
        ArrayDeque<PsiElement> q = new ArrayDeque<PsiElement>();
        q.addLast(root);
        int statementCount = 0;
        int returnCount = 0;
        while (!q.isEmpty() && statementCount++ < statementLimit) {
            int i;
            PsiElement element = (PsiElement)q.removeFirst();
            if (element instanceof PhpReturn || element instanceof PhpYield) {
                ++returnCount;
                type.add(element);
                if (element instanceof PhpYield) {
                    type.add("\\Generator");
                }
                if (element instanceof PhpReturn) {
                    FunctionImpl.visitReturn((PhpReturn)element, type);
                    if (!interactive && returnCount > 3) {
                        return returnCount;
                    }
                }
            }
            PsiElement[] children = element.getChildren();
            int n = i = reverseOrder ? children.length - 1 : 0;
            while (reverseOrder ? i >= 0 : i < children.length) {
                PsiElement child = children[i];
                if (child instanceof Statement) {
                    if (depthFirst) {
                        q.addFirst(child);
                    } else {
                        q.addLast(child);
                    }
                }
                i += reverseOrder ? -1 : 1;
            }
        }
        return returnCount;
    }

    public Collection<String> getDocExceptions() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub instanceof PhpFunctionStub) {
            return ((PhpFunctionStub)stub).getDocExceptions();
        }
        return FunctionImpl.getDocExceptions(this);
    }

    @NotNull
    protected static Collection<String> getDocExceptions(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(18);
        }
        if ((docComment = function.getDocComment()) != null) {
            THashSet docExceptions = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (PhpType type : docComment.getExceptionClasses()) {
                docExceptions.addAll(type.getTypes());
            }
            THashSet tHashSet = docExceptions;
            if (tHashSet == null) {
                FunctionImpl.$$$reportNull$$$0(19);
            }
            return tHashSet;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            FunctionImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            FunctionImpl.$$$reportNull$$$0(21);
        }
        return phpControlFlow;
    }

    @NotNull
    public PhpScope getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl((PhpScopeHolder)this);
        }
        PhpScope phpScope = this.myScope;
        if (phpScope == null) {
            FunctionImpl.$$$reportNull$$$0(22);
        }
        return phpScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            FunctionImpl.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocExceptions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDocExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

