/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.createClass;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewClassDialog;
import com.jetbrains.php.actions.PhpNewClassMockDataProvider;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpDirectoryProvider;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCreateClassQuickFix
extends PhpQuickFixBase {
    static final String ACTION_NAME = "Create New Class QuickFix";
    private static final String SEPARATOR = "/";
    public static final String NAME = PhpBundle.message("quickfix.create.class", new Object[0]);

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        PhpReference classReference = (PhpReference)PhpPsiUtil.getParentByCondition(psiElement, (Condition<? super PsiElement>)((Condition)psiElement1 -> psiElement1 instanceof ClassReference || psiElement1 instanceof PhpDocType));
        if (psiElement instanceof ClassReference) {
            classReference = (ClassReference)psiElement;
        }
        PsiFile file = null;
        if (classReference != null) {
            NewExpression newExpression = null;
            if (!PhpCreateClassQuickFix.isReferenceToInterface(classReference) && !PhpCreateClassQuickFix.isClassReferenceToTrait(classReference)) {
                newExpression = (NewExpression)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)NewExpression.INSTANCEOF);
            }
            file = this.separateFile(project, classReference, containingFile, newExpression, descriptor);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
            PhpDocComment docComment;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PhpClass clazz = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)file, PhpClass.class, (boolean)false);
            PhpDocComment phpDocComment = docComment = clazz != null ? clazz.getDocComment() : null;
            if (docComment != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, docComment.getTextRange()));
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected static void createConstructorAndResolveImports(NewExpression newExpression, @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(4);
        }
        if (newExpression != null) {
            PhpImportClassQuickFix importClassQuickFix = new PhpImportClassQuickFix();
            PhpReference phpReference = PhpBaseImportQuickFix.getReference(descriptor.getPsiElement());
            if (phpReference != null && ((PhpBaseImportQuickFix)importClassQuickFix).getCandidates(project, phpReference).size() > 0) {
                importClassQuickFix.applyFix(project, descriptor);
            }
        }
    }

    public static boolean isClassReferenceToTrait(PhpReference classReference) {
        boolean isReferenceToTrait = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) != null;
        return isReferenceToTrait &= PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null;
    }

    @Nullable
    private PsiFile separateFile(@NotNull Project project, @NotNull PhpReference classReference, PsiFile containingFile, @Nullable NewExpression newExpression, ProblemDescriptor descriptor) {
        PhpNewClassDataProvider dialog;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(5);
        }
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(6);
        }
        String namespaceName = classReference.getNamespaceName();
        boolean isReferenceToInterface = PhpCreateClassQuickFix.isReferenceToInterface(classReference);
        boolean isReferenceToTrait = PhpCreateClassQuickFix.isClassReferenceToTrait(classReference);
        ClassCreationType kindOfTemplate = ClassCreationType.CLASS;
        if (isReferenceToInterface) {
            kindOfTemplate = ClassCreationType.INTERFACE;
        }
        if (isReferenceToTrait) {
            kindOfTemplate = ClassCreationType.TRAIT;
        }
        if ((dialog = this.getDataProvider(project, classReference, kindOfTemplate, containingFile, namespaceName)) != null) {
            PsiDirectory baseDir;
            String filePath;
            PsiFile file;
            FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
            Properties properties = templateManager.getDefaultProperties();
            String name = dialog.getClassName();
            properties.setProperty("NAME", name);
            String namespaceFieldText = dialog.getNamespaceName();
            if (!namespaceFieldText.isEmpty()) {
                properties.setProperty("NAMESPACE", namespaceFieldText);
            }
            if ((file = PhpCreateClassQuickFix.createClassInSeparateFileAndDoFix(project, properties, filePath = dialog.getFilePath(), baseDir = dialog.getBaseDirectory(), ACTION_NAME, dialog.getTemplateName(), newExpression, descriptor)) instanceof PhpFile) {
                PhpPsrNamespaceRootDetector.detectNewRootDirectory(project, (PhpFile)file, properties.getProperty("NAMESPACE"));
            }
            return file;
        }
        return null;
    }

    private static boolean isReferenceToInterface(@NotNull PhpReference classReference) {
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(7);
        }
        boolean firstCase = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof PhpClass && ((PhpClass)element).isInterface())) != null;
        boolean secondCase = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof ImplementsList)) != null;
        return (firstCase &= PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element -> element instanceof ExtendsList)) != null) || secondCase;
    }

    @Nullable
    protected PhpNewClassDataProvider getDataProvider(@NotNull Project project, @NotNull PhpReference classReference, @NotNull ClassCreationType kindOfTemplate, PsiFile containingFile, @NotNull String namespaceName) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(8);
        }
        if (classReference == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(9);
        }
        if (kindOfTemplate == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(10);
        }
        if (namespaceName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(11);
        }
        boolean isEditable = PhpLangUtil.isGlobalNamespaceFQN(namespaceName);
        String namespacePrefill = PhpLangUtil.toName(namespaceName);
        String className = classReference.getName();
        PsiDirectory contextDir = containingFile.getParent();
        PhpDirectoryProvider provider = PhpDirectoryByPsrProvider.getDefaultProvider();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PhpNewClassDialog dialog = PhpCreateClassQuickFix.getDialog(project, className, kindOfTemplate, className, contextDir, provider, namespacePrefill, isEditable);
            if (dialog.showAndGet()) {
                return dialog;
            }
        } else if (contextDir != null) {
            return new PhpNewClassMockDataProvider(project, className, namespacePrefill, kindOfTemplate, className, provider, contextDir);
        }
        return null;
    }

    @Nullable
    public static PsiFile createClassInSeparateFile(@NotNull Project project, Properties properties, String filePath, PsiDirectory baseDir, String actionName, String templateName) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(12);
        }
        Ref fileRef = new Ref(null);
        Ref exceptionRef = new Ref(null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                PhpCreateClassQuickFix.$$$reportNull$$$0(29);
            }
            Runnable run = () -> {
                if (project == null) {
                    PhpCreateClassQuickFix.$$$reportNull$$$0(30);
                }
                try {
                    fileRef.set((Object)PhpCreateClassQuickFix.createClass(project, filePath, baseDir, templateName, null, properties));
                }
                catch (IncorrectOperationException | PhpInvalidTemplateException | IOException e) {
                    exceptionRef.set((Object)e.getMessage());
                }
            };
            ApplicationManager.getApplication().runWriteAction(run);
        }, actionName, null);
        if (!exceptionRef.isNull()) {
            Messages.showErrorDialog((String)((String)exceptionRef.get()), (String)actionName);
            return null;
        }
        return (PsiFile)fileRef.get();
    }

    @Nullable
    public static PsiFile createClassInSeparateFileAndDoFix(@NotNull Project project, Properties properties, String filePath, PsiDirectory baseDir, String actionName, String templateName, NewExpression newExpression, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(13);
        }
        if (descriptor == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(14);
        }
        Ref fileRef = new Ref(null);
        Ref exceptionRef = new Ref(null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                PhpCreateClassQuickFix.$$$reportNull$$$0(25);
            }
            if (descriptor == null) {
                PhpCreateClassQuickFix.$$$reportNull$$$0(26);
            }
            Runnable run = () -> {
                if (project == null) {
                    PhpCreateClassQuickFix.$$$reportNull$$$0(27);
                }
                if (descriptor == null) {
                    PhpCreateClassQuickFix.$$$reportNull$$$0(28);
                }
                try {
                    PsiFile file = PhpCreateClassQuickFix.createClass(project, filePath, baseDir, templateName, newExpression, properties);
                    if (file != null) {
                        fileRef.set((Object)file);
                        PhpCreateClassQuickFix.createConstructorAndResolveImports(newExpression, project, descriptor);
                        PhpCodeUtil.openRelatedFile(project, (PsiElement)file);
                    }
                }
                catch (IncorrectOperationException | PhpInvalidTemplateException | IOException e) {
                    exceptionRef.set((Object)e.getMessage());
                }
            };
            ApplicationManager.getApplication().runWriteAction(run);
        }, actionName, null);
        if (!exceptionRef.isNull()) {
            Messages.showErrorDialog((String)((String)exceptionRef.get()), (String)actionName);
            return null;
        }
        return (PsiFile)fileRef.get();
    }

    @Nullable
    private static PsiFile createClass(@NotNull Project project, @NotNull String filePath, @NotNull PsiDirectory baseDir, @NotNull String templateName, @Nullable NewExpression newExpression, @NotNull Properties properties) throws IOException, PhpInvalidTemplateException, IncorrectOperationException {
        PsiDirectory parentDirectory;
        PsiElement file;
        List path;
        String fileName;
        PsiFile fileTemplate;
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(15);
        }
        if (filePath == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(16);
        }
        if (baseDir == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(17);
        }
        if (templateName == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(18);
        }
        if (properties == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(19);
        }
        if ((fileTemplate = PhpFileTemplateUtil.createPhpFileFromInternalTemplate(project, baseDir, templateName, properties, fileName = (String)(path = StringUtil.split((String)filePath.replace(File.separator, SEPARATOR), (String)SEPARATOR)).get(path.size() - 1))) == null) {
            throw new IncorrectOperationException(PhpBundle.message("error.template.unable.create.from.internal.template", templateName));
        }
        PhpClass phpClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)fileTemplate, PhpClass.class, (boolean)false);
        if (newExpression != null) {
            if (phpClass != null && !phpClass.isInterface() && !phpClass.isTrait()) {
                Pair<PhpDocComment, Method> commentMethodPair = PhpCreateClassQuickFix.createConstructor(project, phpClass, newExpression);
                PsiElement inserted = PhpCodeEditUtil.insertClassMemberWithPhpDoc(phpClass, (PsiElement)commentMethodPair.second, (PhpDocComment)commentMethodPair.first);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
            } else {
                throw new IncorrectOperationException(PhpBundle.message("quickfix.failed.to.create.class", properties.getProperty("NAME")));
            }
        }
        if ((file = (parentDirectory = PhpFileCreator.createDirectory(path, baseDir)).add((PsiElement)fileTemplate)) instanceof PsiFile) {
            return (PsiFile)file;
        }
        return null;
    }

    @NotNull
    private static PhpNewClassDialog getDialog(@NotNull Project project, final @Nullable String className, final @NotNull ClassCreationType kindOfTemplate, final @Nullable String fileName, @Nullable PsiDirectory contextDir, final @NotNull PhpDirectoryProvider provider, final String namespaceName, final boolean isEditable) {
        if (project == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(20);
        }
        if (kindOfTemplate == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(21);
        }
        if (provider == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(22);
        }
        PhpNewClassDialog phpNewClassDialog = new PhpNewClassDialog(project, contextDir){

            @Override
            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myFileNameTextField;
            }

            @Override
            protected void init() {
                super.init();
                this.myTemplateComboBox.setEnabled(false);
                this.myNameTextField.setEnabled(false);
                this.setData(className, kindOfTemplate, fileName, namespaceName);
                this.myNamespaceCombobox.setEnabled(isEditable);
                this.myDirectoryCombobox.setDirectoryProvider(provider);
            }
        };
        if (phpNewClassDialog == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(23);
        }
        return phpNewClassDialog;
    }

    public static Pair<PhpDocComment, Method> createConstructor(Project project, @NotNull PhpClass myClass, NewExpression newExpression) throws PhpInvalidTemplateException {
        if (myClass == null) {
            PhpCreateClassQuickFix.$$$reportNull$$$0(24);
        }
        String constructorTemplate = PhpCodeUtil.getCodeTemplate("PHP Constructor", PhpCreateClassQuickFix.getConstructorAttributes(newExpression, myClass.getName()), project);
        constructorTemplate = constructorTemplate.replaceAll("(\\s*\\n)+", "\n");
        return PhpConstructorGenerator.createConstructorFromTemplate(project, myClass.isInterface(), constructorTemplate);
    }

    private static Properties getConstructorAttributes(NewExpression newExpression, String name) {
        Properties properties = new Properties();
        properties.setProperty("CLASS_NAME", name);
        String makeParameterList = PhpAddMethodDeclarationQuickFix.makeParameterList((PhpExpression)newExpression, null, false);
        String paramsDoc = PhpAddMethodDeclarationQuickFix.getParameterDoc((PhpExpression)newExpression);
        properties.setProperty("PARAM_LIST", makeParameterList.substring(1, makeParameterList.length() - 1));
        properties.setProperty("BODY", "");
        properties.setProperty("PARAM_DOC", paramsDoc);
        properties.setProperty("THROWS_DOC", "");
        return properties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/createClass/PhpCreateClassQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 25: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 14: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindOfTemplate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/createClass/PhpCreateClassQuickFix";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorAndResolveImports";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "separateFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToInterface";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createClassInSeparateFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createClassInSeparateFileAndDoFix";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDialog";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClassInSeparateFileAndDoFix$8";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClassInSeparateFile$6";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

