/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.surroundWith.PhpTryCatchSurrounder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "findStatement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Companion", "intellij.php.impl"})
public final class PhpSurroundWithTryCatchQuickFix
implements LocalQuickFix {
    @NotNull
    private static final PhpSurroundWithTryCatchQuickFix INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return "Surround with try-catch";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"descriptor.psiElement");
        Statement statement = this.findStatement(psiElement);
        Editor editor2 = editor = PsiUtilBase.findEditor((PsiElement)((PsiElement)statement));
        Object caretModel = editor2 != null ? editor2.getCaretModel() : null;
        CaretModel caretModel2 = caretModel;
        int col = caretModel2 != null && (caretModel2 = caretModel2.getLogicalPosition()) != null ? caretModel2.column : 0;
        CaretModel caretModel3 = caretModel;
        int line = caretModel3 != null && (caretModel3 = caretModel3.getLogicalPosition()) != null ? caretModel3.line : 0;
        CaretModel caretModel4 = caretModel;
        if (caretModel4 != null) {
            caretModel4.moveToLogicalPosition(new LogicalPosition(0, 0));
        }
        TextRange textRange = new PhpTryCatchSurrounder().surroundElements(project, (PsiElement[])new Statement[]{statement});
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        TextRange range = textRange;
        if (caretModel != null) {
            caretModel.moveToLogicalPosition(new LogicalPosition(line, col));
            caretModel.moveToOffset(range.getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private final Statement findStatement(PsiElement element) {
        Statement statement;
        Object t = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"PhpPsiUtil.getParentByCo\u2026, Statement.INSTANCEOF)!!");
        Statement statement2 = (Statement)t;
        if (statement2 instanceof ElseIf || statement2 instanceof PhpCase) {
            PsiElement psiElement = statement2.getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Statement");
            }
            statement = (Statement)psiElement;
        } else {
            statement = statement2;
        }
        return statement;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new PhpSurroundWithTryCatchQuickFix();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix;", "getINSTANCE", "()Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix;", "intellij.php.impl"})
    public static final class Companion {
        @NotNull
        public final PhpSurroundWithTryCatchQuickFix getINSTANCE() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

