/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoveStatementFix
implements LocalQuickFix {
    public static final PhpRemoveStatementFix REMOVE_USE = new PhpRemoveStatementFix("use statement", (Condition<PsiElement>)PhpUse.INSTANCEOF, PhpTokenTypes.opCOMMA);
    private final String name;
    private final Condition<PsiElement> condition;
    private final IElementType delivery;

    public PhpRemoveStatementFix(String name, Condition<PsiElement> condition, @Nullable IElementType delivery) {
        this.name = "Remove " + name;
        this.condition = condition;
        this.delivery = delivery;
    }

    public PhpRemoveStatementFix(String name, Condition<PsiElement> condition) {
        this(name, condition, null);
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            PhpRemoveStatementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public final String getFamilyName() {
        if ("remove" == null) {
            PhpRemoveStatementFix.$$$reportNull$$$0(1);
        }
        return "remove";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parentElement;
        PsiElement element;
        if (project == null) {
            PhpRemoveStatementFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveStatementFix.$$$reportNull$$$0(3);
        }
        PsiElement conditionElement = (element = descriptor.getPsiElement()) == null ? null : (PsiElement)PhpPsiUtil.getParentByCondition(element, false, this.condition);
        PsiElement psiElement = parentElement = conditionElement == null ? null : conditionElement.getParent();
        if (parentElement == null) {
            return;
        }
        if (this.delivery == null) {
            parentElement.deleteChildRange(conditionElement, conditionElement);
            return;
        }
        if (parentElement.getChildren().length == 1) {
            parentElement.deleteChildRange(parentElement.getFirstChild(), parentElement.getLastChild());
            return;
        }
        PsiElement prevElement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(conditionElement, true);
        if (PhpRemoveStatementFix.isDelivery(prevElement, this.delivery)) {
            parentElement.deleteChildRange(prevElement, conditionElement);
        } else {
            PsiElement nextElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(conditionElement, true);
            if (PhpRemoveStatementFix.isDelivery(nextElement, this.delivery)) {
                parentElement.deleteChildRange(conditionElement, nextElement);
            }
        }
    }

    private static boolean isDelivery(@Nullable PsiElement element, @NotNull IElementType delivery) {
        if (delivery == null) {
            PhpRemoveStatementFix.$$$reportNull$$$0(4);
        }
        ASTNode node = element == null ? null : element.getNode();
        return node != null && node.getElementType() == delivery;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRemoveStatementFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delivery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRemoveStatementFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDelivery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

