/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<ParameterListOwner, PsiElementResolveResult, PhpPsiElement> {
    private String text;

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        Object o = item.getObject();
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            ArrayList<PsiElementResolveResult> methods = new ArrayList<PsiElementResolveResult>();
            if (element instanceof Function) {
                methods.add(new PsiElementResolveResult(element));
            }
            return ArrayUtil.toObjectArray(methods);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public ParameterListOwner findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return PhpParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public ParameterListOwner findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return PhpParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    @NotNull
    public PhpPsiElement[] getActualParameters(@NotNull ParameterListOwner o) {
        if (o == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(2);
        }
        PsiElement[] parameters = o.getParameters();
        PhpPsiElement[] phpPsiElements = new PhpPsiElement[parameters.length];
        System.arraycopy(parameters, 0, phpPsiElements, 0, parameters.length);
        if (phpPsiElements == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return phpPsiElements;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = PhpTokenTypes.opCOMMA;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = PhpTokenTypes.chRPAREN;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{PhpPsiElement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{Statement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Class<ParameterListOwner> getArgumentListClass() {
        if (ParameterListOwner.class == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return ParameterListOwner.class;
    }

    private static boolean isEmbraced(@Nullable PhpPsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        ASTNode lbrace = node.findChildByType(PhpTokenTypes.chLPAREN);
        ASTNode rbrace = node.findChildByType(PhpTokenTypes.chRPAREN);
        if (lbrace != null && rbrace != null) {
            return lbrace.getStartOffset() < offset && rbrace.getStartOffset() >= offset;
        }
        if (lbrace != null) {
            return lbrace.getStartOffset() <= offset;
        }
        return false;
    }

    @Nullable
    private static ParameterListOwner getReferenceElement(PhpPsiElement element) {
        return element instanceof NewExpression ? (NewExpression)element : (ParameterListOwner)element;
    }

    @Nullable
    private static ParameterListOwner findAnchorElement(int offset, PsiFile file) {
        if (offset <= 0) {
            return null;
        }
        if (file instanceof PhpFile) {
            ParameterListOwner parametersOwner;
            CharSequence chars = file.getViewProvider().getContents();
            if (offset > chars.length()) {
                offset = chars.length();
            }
            if ((offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t\n\r") + 1) <= 0) {
                return null;
            }
            if (chars.charAt(offset - 1) == ',') {
                --offset;
            }
            if ((parametersOwner = (ParameterListOwner)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, ParameterListOwner.class, (boolean)false)) == null) {
                return null;
            }
            if (PhpParameterInfoHandler.isEmbraced((PhpPsiElement)parametersOwner, offset)) {
                ParameterListOwner result = PhpParameterInfoHandler.getReferenceElement((PhpPsiElement)parametersOwner);
                return result instanceof ClassReference ? (ParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)result, NewExpression.class) : result;
            }
            ParameterList parametersList = (ParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, ParameterList.class, (boolean)false);
            if (parametersList != null && PhpParameterInfoHandler.isEmbraced((PhpPsiElement)parametersList.getParent(), offset)) {
                return PhpParameterInfoHandler.getReferenceElement((PhpPsiElement)parametersList.getParent());
            }
        }
        return null;
    }

    public void showParameterInfo(@NotNull ParameterListOwner place, @NotNull CreateParameterInfoContext context) {
        ClassReference classReference;
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(10);
        }
        Object[] variants = ResolveResult.EMPTY_ARRAY;
        if (place instanceof PsiPolyVariantReference) {
            variants = ((PsiPolyVariantReference)place).multiResolve(true);
        } else if (place instanceof NewExpression && (classReference = ((NewExpression)place).getClassReference()) != null) {
            variants = classReference.multiResolve(true);
        }
        context.setItemsToShow(variants);
        context.showHint((PsiElement)(place instanceof ClassReference ? place.getParent() : place), place.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull ParameterListOwner place, @NotNull UpdateParameterInfoContext context) {
        PsiElement contextParameterOwner;
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if ((contextParameterOwner = context.getParameterOwner()) == null) {
            context.setParameterOwner((PsiElement)place);
        } else if (!(contextParameterOwner instanceof PhpPsiElement) || !Objects.equals(PhpParameterInfoHandler.getReferenceElement((PhpPsiElement)contextParameterOwner), PhpParameterInfoHandler.getReferenceElement((PhpPsiElement)place))) {
            context.removeHint();
            return;
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        offset = CharArrayUtil.shiftForward((CharSequence)context.getEditor().getDocument().getText(), (int)offset, (String)" \t\n");
        int currIndex = PhpParameterInfoHandler.getCurrentParameterIndex((PhpPsiElement)place, offset);
        context.setCurrentParameter(currIndex);
        Object[] objects = context.getObjectsToView();
        block0: for (int i = 0; i < objects.length; ++i) {
            PsiElementResolveResult resolveResult = (PsiElementResolveResult)objects[i];
            PsiNamedElement namedElement = (PsiNamedElement)resolveResult.getElement();
            if (!namedElement.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            Object argTypes = null;
            PhpType[] parameterTypes = null;
            if (namedElement instanceof Function) {
                Function function = (Function)namedElement;
                Parameter[] parameters = function.getParameters();
                parameterTypes = new PhpType[parameters.length];
                for (int j = 0; j < parameters.length; ++j) {
                    parameterTypes[j] = parameters[j].getType();
                }
            } else if (namedElement instanceof Variable) {
                // empty if block
            }
            if (argTypes == null) continue;
            if (parameterTypes.length <= currIndex) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PhpIndex phpIndex = PhpIndex.getInstance((Project)place.getProject());
            for (int j = 0; j < currIndex; ++j) {
                void argType = argTypes[j];
                if (parameterTypes[j].isConvertibleFrom((PhpType)argType, phpIndex)) continue;
                context.setUIComponentEnabled(i, false);
                break block0;
            }
            context.setUIComponentEnabled(i, true);
        }
    }

    private static int getCurrentParameterIndex(PhpPsiElement place, int offset) {
        if (place instanceof ClassReference) {
            place = (PhpPsiElement)place.getParent();
        }
        if (place instanceof FunctionReference || place instanceof NewExpression) {
            ParameterList[] parameterLists = (ParameterList[])PsiTreeUtil.getChildrenOfType((PsiElement)place, ParameterList.class);
            if (parameterLists == null || parameterLists.length != 1 || parameterLists[0] == null) {
                return -1;
            }
            ParameterList parameterList = parameterLists[0];
            offset -= parameterList.getTextRange().getStartOffset();
            ASTNode astNode = parameterList.getNode();
            if (astNode == null) {
                return -1;
            }
            int index = 0;
            for (ASTNode child : astNode.getChildren(null)) {
                if (child.getElementType() == PhpTokenTypes.opCOMMA) {
                    ++index;
                }
                if ((offset -= child.getTextLength()) > 0) continue;
                return index;
            }
            return index;
        }
        return -1;
    }

    public void updateUI(PsiElementResolveResult resolveResult, @NotNull ParameterInfoUIContext context) {
        Method constructor;
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(13);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        PsiNamedElement element = (PsiNamedElement)resolveResult.getElement();
        if (!element.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        StringBuilder buffer = new StringBuilder();
        if (element instanceof PhpClass && (constructor = ((PhpClass)element).getConstructor()) != null) {
            element = constructor;
        }
        if (element instanceof Function) {
            Function function = (Function)element;
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(element.getName());
                buffer.append("(");
            }
            int currentParameter = context.getCurrentParameterIndex();
            Parameter[] parms = function.getParameters();
            int numParams = parms.length;
            if (numParams > 0) {
                for (int j = 0; j < numParams; ++j) {
                    Parameter parm = parms[j];
                    int startOffset = buffer.length();
                    buffer.append(PhpPresentationUtil.getParameterPresentation(parm));
                    int endOffset = buffer.length();
                    if (j < numParams - 1) {
                        buffer.append(", ");
                    }
                    if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !parm.isVariadic() || currentParameter < numParams)) continue;
                    highlightStartOffset = startOffset;
                    highlightEndOffset = endOffset;
                }
            } else {
                buffer.append("no parameters");
            }
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(")");
                PhpType returnType = function.getType();
                if (!returnType.isUndefined()) {
                    PhpPresentationUtil.formatType(buffer, (PhpNamedElement)function);
                }
            }
        } else if (element instanceof PhpClass) {
            buffer.append("no parameters");
        } else if (element instanceof Variable) {
            // empty if block
        }
        boolean isDeprecated = false;
        this.text = buffer.toString();
        context.setupUIComponentPresentation(this.text, highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public String getText() {
        return this.text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

