/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentRefactoring;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "Companion", "intellij.vuejs"})
public final class VueExtractComponentIntention
extends JavaScriptIntention {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return VueBundle.Companion.message("vue.template.intention.extract.component.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return VueBundle.Companion.message("vue.template.intention.extract.component", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (editor == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (Intrinsics.areEqual((Object)((Object)VueFileType.Companion.getINSTANCE()), (Object)(psiFile != null ? psiFile.getFileType() : null)) ^ true) {
            return false;
        }
        return Companion.getContext(editor, element) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (editor == null) {
            return;
        }
        List<XmlTag> list = Companion.getContext(editor, element);
        if (list == null) {
            return;
        }
        List<XmlTag> context = list;
        VueExtractComponentRefactoring.perform$default(new VueExtractComponentRefactoring(project, context, editor), null, 1, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentIntention$Companion;", "", "()V", "getContext", "", "Lcom/intellij/psi/xml/XmlTag;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getSelectedTags", "intellij.vuejs"})
    public static final class Companion {
        @Nullable
        public final List<XmlTag> getContext(@Nullable Editor editor, @NotNull PsiElement element) {
            List<XmlTag> selectedTags;
            block9: {
                block8: {
                    boolean bl;
                    block7: {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        selectedTags = this.getSelectedTags(element, editor);
                        if (selectedTags == null) break block8;
                        Iterable $receiver$iv = selectedTags;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                XmlTag it = (XmlTag)element$iv;
                                if (!(PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)it), XmlTag.class) == null)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block9;
                }
                return null;
            }
            return selectedTags;
        }

        private final List<XmlTag> getSelectedTags(PsiElement element, Editor editor) {
            PsiFile file = element.getContainingFile();
            if (file == null) {
                return null;
            }
            if (element.getNode() == null) {
                return null;
            }
            if (editor == null || !editor.getSelectionModel().hasSelection()) {
                XmlTag parent2;
                ASTNode aSTNode = element.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                IElementType iElementType = aSTNode.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
                IElementType type = iElementType;
                PsiElement psiElement = element.getParent();
                if (!(psiElement instanceof XmlTag)) {
                    psiElement = null;
                }
                if ((parent2 = (XmlTag)psiElement) != null && (Intrinsics.areEqual((Object)type, (Object)XmlElementType.XML_NAME) || Intrinsics.areEqual((Object)type, (Object)XmlElementType.XML_START_TAG_START) || Intrinsics.areEqual((Object)type, (Object)XmlElementType.XML_TAG_NAME))) {
                    return CollectionsKt.listOf((Object)parent2);
                }
                if (element instanceof XmlTag) {
                    return CollectionsKt.listOf((Object)element);
                }
                return null;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
            int start = selectionModel.getSelectionStart();
            SelectionModel selectionModel2 = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
            int end = selectionModel2.getSelectionEnd();
            List list = new ArrayList();
            while (start < end) {
                XmlTag tag;
                while (file.findElementAt(start) instanceof PsiWhiteSpace && start < end) {
                    ++start;
                }
                if (start == end) break;
                if ((XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)start, XmlTag.class, (boolean)true) == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"PsiTreeUtil.findElementO\u2026ava, true) ?: return null");
                TextRange textRange = tag.getTextRange();
                TextRange textRange2 = textRange;
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"textRange");
                int n = textRange2.getStartOffset();
                if (start > n) break;
                if (end - 1 < n) {
                    break;
                }
                if (textRange.getEndOffset() > end) {
                    return null;
                }
                list.add(tag);
                start = textRange.getEndOffset();
            }
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

