/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002R0\u0010\u0004\u001a$\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a$\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/codeInsight/completion/VueTagAttributeCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "VUE_SCRIPT_LANGUAGE", "", "", "kotlin.jvm.PlatformType", "", "VUE_STYLE_LANGUAGE", "VUE_TEMPLATE_LANGUAGE", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "listOfCompletions", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "vueStyleLanguages", "intellij.vuejs"})
final class VueTagAttributeCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final Set<String> VUE_SCRIPT_LANGUAGE;
    private final Set<String> VUE_STYLE_LANGUAGE;
    private final Set<String> VUE_TEMPLATE_LANGUAGE;

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlTag.class, (boolean)false);
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttribute.class, (boolean)false);
        if (xmlTag == null || xmlAttribute == null) {
            return;
        }
        for (String completion : this.listOfCompletions(xmlTag, xmlAttribute)) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)completion));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Set<String> listOfCompletions(XmlTag xmlTag, XmlAttribute xmlAttribute) {
        if (Intrinsics.areEqual((Object)xmlAttribute.getName(), (Object)"lang")) {
            String string = xmlTag.getName();
            switch (string.hashCode()) {
                case -1321546630: {
                    if (!string.equals("template")) break;
                    return this.VUE_TEMPLATE_LANGUAGE;
                }
                case 109780401: {
                    if (!string.equals("style")) break;
                    return this.VUE_STYLE_LANGUAGE;
                }
                case -907685685: {
                    if (!string.equals("script")) break;
                    return this.VUE_SCRIPT_LANGUAGE;
                }
            }
        }
        Set set = ContainerUtil.immutableSet((Object[])new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.immutableSet()");
        return set;
    }

    private final Set<String> vueStyleLanguages() {
        List result = new ArrayList();
        result.add("css");
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)cSSLanguage, (String)"CSSLanguage.INSTANCE");
        List list = cSSLanguage.getDialects();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"CSSLanguage.INSTANCE.dialects");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String string;
            String string2;
            Language it;
            Language language = it = (Language)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"it");
            if (!(Intrinsics.areEqual((Object)language.getDisplayName(), (Object)"JQuery-CSS") ^ true)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getDisplayName(), (String)"it.displayName");
            List list2 = result;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            list2.add(string);
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    public VueTagAttributeCompletionProvider() {
        Set set = ContainerUtil.immutableSet((Object[])new String[]{"js", "ts"});
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.immutableSet(\"js\", \"ts\")");
        this.VUE_SCRIPT_LANGUAGE = set;
        this.VUE_STYLE_LANGUAGE = this.vueStyleLanguages();
        Set set2 = ContainerUtil.immutableSet((Object[])new String[]{"html", "pug"});
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"ContainerUtil.immutableSet(\"html\", \"pug\")");
        this.VUE_TEMPLATE_LANGUAGE = set2;
    }
}

