/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.model.SwarmNode;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSwarmNodesCmdExec
extends AbstrSyncDockerCmdExec<ListSwarmNodesCmd, List<SwarmNode>>
implements ListSwarmNodesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSwarmNodesCmdExec.class);

    public ListSwarmNodesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<SwarmNode> execute(ListSwarmNodesCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/nodes");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters()))});
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List nodes = (List)webTarget.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<SwarmNode>>(){});
        LOGGER.trace("Response: {}", (Object)nodes);
        return nodes;
    }
}

