/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTaskTreeView
extends JsbtTaskTreeView {
    private static final String NO_TASKS_FOUND = "No tasks found";

    public GulpTaskTreeView(@NotNull GulpService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            GulpTaskTreeView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GulpTaskTreeView.$$$reportNull$$$0(1);
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            GulpTaskTreeView.$$$reportNull$$$0(2);
        }
        if (_structure == null) {
            GulpTaskTreeView.$$$reportNull$$$0(3);
        }
        GulpfileStructure structure = (GulpfileStructure)_structure;
        for (GulpTask task : structure.getTasks()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(task, false));
        }
        if (structure.getTasks().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(NO_TASKS_FOUND, false));
        }
    }

    @Override
    protected int compareNodes(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2, @NotNull JsbtSortingMode sortingMode) {
        if (node1 == null) {
            GulpTaskTreeView.$$$reportNull$$$0(4);
        }
        if (node2 == null) {
            GulpTaskTreeView.$$$reportNull$$$0(5);
        }
        if (sortingMode == null) {
            GulpTaskTreeView.$$$reportNull$$$0(6);
        }
        GulpTask task1 = GulpTask.getUserObject(node1);
        GulpTask task2 = GulpTask.getUserObject(node2);
        if (task1 == null || task2 == null) {
            if (task1 == null && task2 == null) {
                return 0;
            }
            return task1 == null ? 1 : -1;
        }
        if (sortingMode == JsbtSortingMode.NAME) {
            return task1.getName().compareTo(task2.getName());
        }
        return GulpTaskTreeView.getPosition(task1) - GulpTaskTreeView.getPosition(task2);
    }

    private static int getPosition(@NotNull GulpTask task) {
        if (task == null) {
            GulpTaskTreeView.$$$reportNull$$$0(7);
        }
        return task.getStructure().getTasks().indexOf(task);
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode buildfileTreeNode) {
        if (buildfileTreeNode == null) {
            GulpTaskTreeView.$$$reportNull$$$0(8);
        }
        int childCount = buildfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)buildfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            GulpTask task = GulpTask.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        GulpfileStructure structure;
        if (project == null) {
            GulpTaskTreeView.$$$reportNull$$$0(9);
        }
        if (renderer == null) {
            GulpTaskTreeView.$$$reportNull$$$0(10);
        }
        if (node == null) {
            GulpTaskTreeView.$$$reportNull$$$0(11);
        }
        if ((structure = GulpfileStructure.getUserObject(node)) != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.Gulp16);
            renderer.setIconOnTheRight(false);
            renderer.append(JsbtUtil.getRelativePath(project, structure.getGulpfile()));
            return;
        }
        if (NO_TASKS_FOUND.equals(node.getUserObject())) {
            renderer.append(NO_TASKS_FOUND, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        GulpTask task = GulpTask.getUserObject(node);
        if (task != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.BuildToolTask);
            List<String> dependencies = task.getDependencies();
            SimpleTextAttributes nameAttr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if ("default".equals(task.getName())) {
                nameAttr = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            renderer.append(task.getName(), nameAttr);
            if (!dependencies.isEmpty()) {
                renderer.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.append(StringUtil.join(dependencies, (String)", "), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@NotNull DefaultMutableTreeNode node) {
        GulpfileStructure structure;
        if (node == null) {
            GulpTaskTreeView.$$$reportNull$$$0(12);
        }
        if ((structure = GulpfileStructure.getUserObject(node)) != null) {
            return structure.getBuildfile().getPath();
        }
        GulpTask task = GulpTask.getUserObject(node);
        return task != null ? task.getName() : null;
    }

    @Override
    protected String getPresentableTaskName(@NotNull DefaultMutableTreeNode node) {
        GulpTask task;
        if (node == null) {
            GulpTaskTreeView.$$$reportNull$$$0(13);
        }
        return (task = GulpTask.getUserObject(node)) != null ? task.getName() : null;
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        GulpfileStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            String taskName;
            GulpfileStructure structure = GulpfileStructure.getUserObject(node);
            if (structure != null) {
                taskName = "default";
            } else {
                GulpTask task = GulpTask.getUserObject(node);
                if (task == null) {
                    return null;
                }
                structure = task.getStructure();
                taskName = task.getName();
            }
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            if (taskNames.contains(taskName)) continue;
            taskNames.add(taskName);
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected Navigatable createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        GulpTask task;
        if (project == null) {
            GulpTaskTreeView.$$$reportNull$$$0(14);
        }
        if (node == null) {
            GulpTaskTreeView.$$$reportNull$$$0(15);
        }
        if ((task = GulpTask.getUserObject(node)) != null) {
            Location location;
            GulpfilePsiStructure psiStructure;
            JSCallExpression callExpression;
            VirtualFile virtualGulpfile = task.getStructure().getGulpfile();
            if (!virtualGulpfile.isValid()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualGulpfile);
            if (psiFile instanceof JSFile && (callExpression = (psiStructure = GulpfilePsiStructure.get((JSFile)psiFile)).getPsiByName(task.getName())) != null && (location = PsiLocation.fromPsiElement((PsiElement)callExpression)) != null) {
                return location.getOpenFileDescriptor();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_structure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildfileChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compareNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTaskNodes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCell";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistentId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableTaskName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createJumpToSourceDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

