/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;

public class Timer {
    public static final Timer instance = new Timer();
    private String myActivityName = "default";
    private volatile long myStartTime;
    private volatile long myStopTime;
    private volatile long myLongestDelay;
    private final AtomicLong myTotalDelay = new AtomicLong();
    private final AtomicLong myCounter = new AtomicLong();
    private ScheduledExecutorService executor;
    private long totalTime;

    public void start() {
        this.start("default");
    }

    public void start(String activityName) {
        this.myActivityName = activityName;
        this.myStartTime = System.currentTimeMillis();
        this.myLongestDelay = 0L;
        this.myTotalDelay.set(0L);
        this.myCounter.set(0L);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(() -> {
            long before = System.currentTimeMillis();
            try {
                SwingUtilities.invokeAndWait(() -> {});
                long after = System.currentTimeMillis();
                long delay = after - before;
                this.myTotalDelay.accumulateAndGet(delay, (left, right) -> left + right);
                this.myCounter.incrementAndGet();
                if (this.myLongestDelay < delay) {
                    this.myLongestDelay = delay;
                }
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.myStopTime = System.currentTimeMillis();
        this.totalTime = this.myStopTime - this.myStartTime;
        this.executor.shutdownNow();
    }

    public void reportToTeamCity() {
        Timer.logValue(this.myActivityName, this.totalTime);
        Timer.logValue(this.myActivityName + " | Responsiveness", this.getLongestDelay());
        Timer.logValue(this.myActivityName + " | Average Responsiveness", this.getAverageDelay());
    }

    public long getLongestDelay() {
        return this.myLongestDelay;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getStopTime() {
        return this.myStopTime;
    }

    public long getAverageDelay() {
        long counterValue = this.myCounter.get();
        return counterValue != 0L ? this.myTotalDelay.get() / counterValue : 0L;
    }

    public String getActivityName() {
        return this.myActivityName;
    }

    public boolean isStarted() {
        return this.executor != null && !this.executor.isShutdown();
    }

    private static void logValue(String key, long value) {
        if (value >= 0L) {
            System.out.printf("##teamcity[buildStatisticValue key='%s' value='%d']", key, value);
            System.out.println();
        }
    }
}

