/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.tags;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.util.XmlUtil;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.angular2.codeInsight.Angular2Processor;
import org.angular2.codeInsight.tags.Angular2TagDescriptor;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveSelectorPsiElement;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.angular2.lang.selector.Angular2SelectorMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2TagDescriptorsProvider
implements XmlElementDescriptorProvider,
XmlTagNameProvider {
    private static final String NG_CONTAINER = "ng-container";
    private static final String NG_CONTENT = "ng-content";
    private static final String NG_TEMPLATE = "ng-template";

    public void addTagNameVariants(@NotNull List<LookupElement> elements, @NotNull XmlTag xmlTag, String prefix) {
        if (elements == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (xmlTag == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(1);
        }
        if (!(xmlTag instanceof HtmlTag) || !Angular2LangUtil.isAngular2Context((PsiElement)xmlTag)) {
            return;
        }
        Project project = xmlTag.getProject();
        Language language = xmlTag.getContainingFile().getLanguage();
        HashSet<String> names = new HashSet<String>();
        for (LookupElement el : elements) {
            names.add(el.getLookupString());
        }
        Angular2EntitiesProvider.getAllElementDirectives(project).forEach((name, list) -> {
            if (elements == null) {
                Angular2TagDescriptorsProvider.$$$reportNull$$$0(16);
            }
            if (!names.contains(name) && !list.isEmpty()) {
                Angular2DirectiveSelectorPsiElement el = ((Angular2Directive)list.get(0)).getSelector().getPsiElementForElement((String)name);
                Angular2TagDescriptorsProvider.addLookupItem(language, elements, (Object)el, name);
            }
        });
        Angular2TagDescriptorsProvider.addLookupItem(language, elements, NG_CONTAINER);
        Angular2TagDescriptorsProvider.addLookupItem(language, elements, NG_CONTENT);
        Angular2TagDescriptorsProvider.addLookupItem(language, elements, NG_TEMPLATE);
    }

    private static void addLookupItem(@NotNull Language language, @NotNull List<LookupElement> elements, @NotNull String name) {
        if (language == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(3);
        }
        if (name == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(4);
        }
        Angular2TagDescriptorsProvider.addLookupItem(language, elements, name, name);
    }

    private static void addLookupItem(@NotNull Language language, @NotNull List<LookupElement> elements, @NotNull Object component, @NotNull String name) {
        if (language == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(6);
        }
        if (component == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(7);
        }
        if (name == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(8);
        }
        LookupElementBuilder element = LookupElementBuilder.create((Object)component, (String)name).withIcon(AngularJSIcons.Angular2);
        if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            element = element.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        }
        elements.add((LookupElement)element);
    }

    @Nullable
    public XmlElementDescriptor getDescriptor(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(9);
        }
        Project project = xmlTag.getProject();
        if (!(xmlTag instanceof HtmlTag) || !Angular2LangUtil.isAngular2Context((PsiElement)xmlTag)) {
            return null;
        }
        String tagName = xmlTag.getName();
        if (XmlUtil.isTagDefinedByNamespace((XmlTag)xmlTag)) {
            return null;
        }
        if (NG_CONTAINER.equalsIgnoreCase(tagName = XmlUtil.findLocalNameByQualifiedName((String)tagName)) || NG_CONTENT.equalsIgnoreCase(tagName) || NG_TEMPLATE.equalsIgnoreCase(tagName)) {
            return new Angular2TagDescriptor(tagName, (PsiElement)Angular2TagDescriptorsProvider.createDirective(xmlTag, tagName));
        }
        List<Angular2Directive> directiveCandidates = Angular2EntitiesProvider.findElementDirectivesCandidates(project, tagName);
        if (directiveCandidates.isEmpty()) {
            return null;
        }
        List<Angular2Directive> matchedDirectives = Angular2TagDescriptorsProvider.matchDirectives(xmlTag, directiveCandidates);
        return new Angular2TagDescriptor(tagName, (PsiElement)(matchedDirectives.isEmpty() ? directiveCandidates : matchedDirectives).get(0).getSelector().getPsiElementForElement(tagName));
    }

    @NotNull
    public static List<Angular2Directive> matchDirectives(@NotNull XmlTag xmlTag, @NotNull Collection<Angular2Directive> directiveCandidates) {
        if (xmlTag == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(10);
        }
        if (directiveCandidates == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(11);
        }
        Angular2SelectorMatcher<Angular2Directive> matcher = new Angular2SelectorMatcher<Angular2Directive>();
        directiveCandidates.forEach(d -> matcher.addSelectables(d.getSelector().getSimpleSelectors(), (Angular2Directive)d));
        boolean isTemplateTag = Angular2Processor.isTemplateTag(xmlTag.getName());
        ArrayList<Angular2Directive> matchedDirectives = new ArrayList<Angular2Directive>();
        Angular2DirectiveSimpleSelector tagInfo = Angular2DirectiveSimpleSelector.createElementCssSelector(xmlTag);
        matcher.match(tagInfo, (selector, directive) -> {
            if (!directive.isTemplate() || isTemplateTag) {
                matchedDirectives.add((Angular2Directive)directive);
            }
        });
        ArrayList<Angular2Directive> arrayList = matchedDirectives;
        if (arrayList == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static JSImplicitElementImpl createDirective(@NotNull XmlTag xmlTag, @NotNull String name) {
        if (xmlTag == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(13);
        }
        if (name == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(14);
        }
        JSImplicitElementImpl jSImplicitElementImpl = new JSImplicitElementImpl.Builder(name, (PsiElement)xmlTag).setTypeString("E;;;").toImplicitElement();
        if (jSImplicitElementImpl == null) {
            Angular2TagDescriptorsProvider.$$$reportNull$$$0(15);
        }
        return jSImplicitElementImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveCandidates";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/tags/Angular2TagDescriptorsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/tags/Angular2TagDescriptorsProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matchDirectives";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTagNameVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchDirectives";
                break;
            }
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDirective";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTagNameVariants$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

