<?php
/**
 * Title: Call to action with locations
 * Slug: twentytwentyfive/cta-book-locations
 * Categories: call-to-action
 * Description: A call to action section with links to get the book in the most popular locations.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_Five
 * @since Twenty Twenty-Five 1.0
 */

?>
<!-- wp:group {"align":"full","className":"is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)">
	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|80"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column {"width":"60%"} -->
		<div class="wp-block-column" style="flex-basis:60%">
			<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|30"}}},"layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap"}} -->
			<div class="wp-block-group" style="padding-bottom:var(--wp--preset--spacing--30)">
				<!-- wp:heading -->
				<h2 class="wp-block-heading"><?php esc_html_e( 'International editions', 'twentytwentyfive' ); ?></h2>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"fontSize":"medium"} -->
				<p class="has-medium-font-size"><?php esc_html_e( 'The Stories Book will be available from these international retailers.', 'twentytwentyfive' ); ?></p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"width":"40%"} -->
		<div class="wp-block-column" style="flex-basis:40%">
			<!-- wp:columns -->
			<div class="wp-block-columns">
				<!-- wp:column {"width":"","style":{"spacing":{"blockGap":"var:preset|spacing|50"}}} -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Australia', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Brazil', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Canada', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Japan', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->

				<!-- wp:column {"width":"","style":{"spacing":{"blockGap":"var:preset|spacing|50"}}} -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'New Zealand', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'Switzerland', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'United States', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained","justifyContent":"left"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"500"}},"fontSize":"large"} -->
						<h3 class="wp-block-heading has-large-font-size" style="font-style:normal;font-weight:500"><?php esc_html_e( 'United Kingdom', 'twentytwentyfive' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"medium"} -->
						<p class="has-medium-font-size"><a href="#"><?php esc_html_e( 'Book Store', 'twentytwentyfive' ); ?></a></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
