/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteVpnGateway
extends BaseCmd {
    private String vpnGatewayId;

    public DeleteVpnGateway(String[] args) {
        super("ec2delvgw", "ec2-delete-vpn-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "VPN_GATEWAY";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a VPN gateway. The VPN_GATEWAY parameter is the ID of the VPN");
        System.out.println("     gateway you want to delete.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.vpnGatewayId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteVpnGateway(this.vpnGatewayId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "VPNGATEWAY", this.vpnGatewayId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("VPN_GATEWAY");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteVpnGateway(args).invoke();
    }
}

