/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.EvaluationMonitor;

public abstract class EvaluationErrorPrinter<T>
implements EvaluationMonitor<T> {
    protected PrintStream printStream;

    protected EvaluationErrorPrinter(OutputStream outputStream) {
        this.printStream = new PrintStream(outputStream);
    }

    protected void printError(Span[] references, Span[] predictions, T referenceSample, T predictedSample, String sentence) {
        ArrayList<Span> falseNegatives = new ArrayList<Span>();
        ArrayList<Span> falsePositives = new ArrayList<Span>();
        this.findErrors(references, predictions, falseNegatives, falsePositives);
        if (falsePositives.size() + falseNegatives.size() > 0) {
            this.printSamples(referenceSample, predictedSample);
            this.printErrors(falsePositives, falseNegatives, sentence);
        }
    }

    protected void printError(String id, Span[] references, Span[] predictions, T referenceSample, T predictedSample, String[] sentenceTokens) {
        ArrayList<Span> falseNegatives = new ArrayList<Span>();
        ArrayList<Span> falsePositives = new ArrayList<Span>();
        this.findErrors(references, predictions, falseNegatives, falsePositives);
        if (falsePositives.size() + falseNegatives.size() > 0) {
            if (id != null) {
                this.printStream.println("Id: {" + id + "}");
            }
            this.printSamples(referenceSample, predictedSample);
            this.printErrors(falsePositives, falseNegatives, sentenceTokens);
        }
    }

    protected void printError(Span[] references, Span[] predictions, T referenceSample, T predictedSample, String[] sentenceTokens) {
        this.printError(null, references, predictions, referenceSample, predictedSample, sentenceTokens);
    }

    protected void printError(String[] references, String[] predictions, T referenceSample, T predictedSample, String[] sentenceTokens) {
        ArrayList<String> filteredDoc = new ArrayList<String>();
        ArrayList<String> filteredRefs = new ArrayList<String>();
        ArrayList<String> filteredPreds = new ArrayList<String>();
        for (int i = 0; i < references.length; ++i) {
            if (references[i].equals(predictions[i])) continue;
            filteredDoc.add(sentenceTokens[i]);
            filteredRefs.add(references[i]);
            filteredPreds.add(predictions[i]);
        }
        if (filteredDoc.size() > 0) {
            this.printSamples(referenceSample, predictedSample);
            this.printErrors(filteredDoc, filteredRefs, filteredPreds);
        }
    }

    protected void printError(T referenceSample, T predictedSample) {
        this.printSamples(referenceSample, predictedSample);
        this.printStream.println();
    }

    private void printErrors(List<String> filteredDoc, List<String> filteredRefs, List<String> filteredPreds) {
        this.printStream.println("Errors: {");
        this.printStream.println("Tok: Ref | Pred");
        this.printStream.println("---------------");
        for (int i = 0; i < filteredDoc.size(); ++i) {
            this.printStream.println(filteredDoc.get(i) + ": " + filteredRefs.get(i) + " | " + filteredPreds.get(i));
        }
        this.printStream.println("}\n");
    }

    private void printErrors(List<Span> falsePositives, List<Span> falseNegatives, String doc) {
        this.printStream.println("False positives: {");
        for (Span span : falsePositives) {
            this.printStream.println(span.getCoveredText(doc));
        }
        this.printStream.println("} False negatives: {");
        for (Span span : falseNegatives) {
            this.printStream.println(span.getCoveredText(doc));
        }
        this.printStream.println("}\n");
    }

    private void printErrors(List<Span> falsePositives, List<Span> falseNegatives, String[] toks) {
        this.printStream.println("False positives: {");
        this.printStream.println(this.print(falsePositives, toks));
        this.printStream.println("} False negatives: {");
        this.printStream.println(this.print(falseNegatives, toks));
        this.printStream.println("}\n");
    }

    private String print(List<Span> spans, String[] toks) {
        return Arrays.toString(Span.spansToStrings(spans.toArray(new Span[spans.size()]), toks));
    }

    private <S> void printSamples(S referenceSample, S predictedSample) {
        String details = "Expected: {\n" + referenceSample + "}\nPredicted: {\n" + predictedSample + "}";
        this.printStream.println(details);
    }

    private void findErrors(Span[] references, Span[] predictions, List<Span> falseNegatives, List<Span> falsePositives) {
        falseNegatives.addAll(Arrays.asList(references));
        falsePositives.addAll(Arrays.asList(predictions));
        for (int referenceIndex = 0; referenceIndex < references.length; ++referenceIndex) {
            Span referenceName = references[referenceIndex];
            for (int predictedIndex = 0; predictedIndex < predictions.length; ++predictedIndex) {
                if (!referenceName.equals(predictions[predictedIndex])) continue;
                falseNegatives.remove(referenceName);
                falsePositives.remove(predictions[predictedIndex]);
            }
        }
    }

    @Override
    public void correctlyClassified(T reference, T prediction) {
    }

    @Override
    public abstract void missclassified(T var1, T var2);
}

