/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
extends IndexWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    public static final String COMMIT_TIME_MSEC_KEY = "commitTimeMSec";
    public static final String COMMIT_COMMAND_VERSION = "commitCommandVer";
    private final Object CLOSE_LOCK = new Object();
    String name;
    private DirectoryFactory directoryFactory;
    private InfoStream infoStream;
    private Directory directory;
    private long majorMergeDocs = 524288L;
    private Timer majorMerge;
    private Timer minorMerge;
    private Meter majorMergedDocs;
    private Meter majorDeletedDocs;
    private Counter mergeErrors;
    private Meter flushMeter;
    private boolean mergeTotals = false;
    private boolean mergeDetails = false;
    private final AtomicInteger runningMajorMerges = new AtomicInteger();
    private final AtomicInteger runningMinorMerges = new AtomicInteger();
    private final AtomicInteger runningMajorMergesSegments = new AtomicInteger();
    private final AtomicInteger runningMinorMergesSegments = new AtomicInteger();
    private final AtomicLong runningMajorMergesDocs = new AtomicLong();
    private final AtomicLong runningMinorMergesDocs = new AtomicLong();
    private final SolrMetricsContext solrMetricsContext;
    private final Map<String, Long> runningMerges = new ConcurrentHashMap<String, Long>();
    private volatile boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrIndexWriter create(SolrCore core, String name, String path, DirectoryFactory directoryFactory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy, Codec codec) throws IOException {
        SolrIndexWriter w = null;
        Directory d = directoryFactory.get(path, DirectoryFactory.DirContext.DEFAULT, config.lockType);
        try {
            w = new SolrIndexWriter(core, name, path, d, create, schema, config, delPolicy, codec);
            w.setDirectoryFactory(directoryFactory);
            SolrIndexWriter solrIndexWriter = w;
            return solrIndexWriter;
        }
        finally {
            if (null == w && null != d) {
                directoryFactory.doneWithDirectory(d);
                directoryFactory.release(d);
            }
        }
    }

    public SolrIndexWriter(String name, Directory d, IndexWriterConfig conf) throws IOException {
        super(d, conf);
        this.name = name;
        this.infoStream = conf.getInfoStream();
        this.directory = d;
        numOpens.incrementAndGet();
        log.debug("Opened Writer {}", (Object)name);
        this.mergeTotals = false;
        this.mergeDetails = false;
        this.solrMetricsContext = null;
    }

    private SolrIndexWriter(SolrCore core, String name, String path, Directory directory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy, Codec codec) throws IOException {
        super(directory, config.toIndexWriterConfig(core).setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(delPolicy).setCodec(codec));
        log.debug("Opened Writer {}", (Object)name);
        this.name = name;
        this.infoStream = this.getConfig().getInfoStream();
        this.directory = directory;
        numOpens.incrementAndGet();
        this.solrMetricsContext = core.getSolrMetricsContext().getChildContext((Object)this);
        if (config.metricsInfo != null && config.metricsInfo.initArgs != null) {
            Object v = config.metricsInfo.initArgs.get("majorMergeDocs");
            if (v != null) {
                try {
                    this.majorMergeDocs = Long.parseLong(String.valueOf(v));
                }
                catch (Exception e) {
                    log.warn("Invalid 'majorMergeDocs' argument, using default 512k", (Throwable)e);
                }
            }
            Boolean Totals = config.metricsInfo.initArgs.getBooleanArg("merge");
            Boolean Details = config.metricsInfo.initArgs.getBooleanArg("mergeDetails");
            this.mergeDetails = Details != null ? Details : false;
            this.mergeTotals = Totals != null ? Totals : false;
            if (this.mergeDetails) {
                this.mergeTotals = true;
                this.majorMergedDocs = this.solrMetricsContext.meter(null, "docs", SolrInfoBean.Category.INDEX.toString(), "merge", "major");
                this.majorDeletedDocs = this.solrMetricsContext.meter(null, "deletedDocs", SolrInfoBean.Category.INDEX.toString(), "merge", "major");
            }
            if (this.mergeTotals) {
                this.minorMerge = this.solrMetricsContext.timer(null, "minor", SolrInfoBean.Category.INDEX.toString(), "merge");
                this.majorMerge = this.solrMetricsContext.timer(null, "major", SolrInfoBean.Category.INDEX.toString(), "merge");
                this.mergeErrors = this.solrMetricsContext.counter(null, "errors", SolrInfoBean.Category.INDEX.toString(), "merge");
                String tag = core.getMetricTag();
                this.solrMetricsContext.gauge(null, () -> this.runningMajorMerges.get(), true, "running", SolrInfoBean.Category.INDEX.toString(), "merge", "major");
                this.solrMetricsContext.gauge(null, () -> this.runningMinorMerges.get(), true, "running", SolrInfoBean.Category.INDEX.toString(), "merge", "minor");
                this.solrMetricsContext.gauge(null, () -> this.runningMajorMergesDocs.get(), true, "running.docs", SolrInfoBean.Category.INDEX.toString(), "merge", "major");
                this.solrMetricsContext.gauge(null, () -> this.runningMinorMergesDocs.get(), true, "running.docs", SolrInfoBean.Category.INDEX.toString(), "merge", "minor");
                this.solrMetricsContext.gauge(null, () -> this.runningMajorMergesSegments.get(), true, "running.segments", SolrInfoBean.Category.INDEX.toString(), "merge", "major");
                this.solrMetricsContext.gauge(null, () -> this.runningMinorMergesSegments.get(), true, "running.segments", SolrInfoBean.Category.INDEX.toString(), "merge", "minor");
                this.flushMeter = this.solrMetricsContext.meter(null, "flush", SolrInfoBean.Category.INDEX.toString());
            }
        }
    }

    @SuppressForbidden(reason="Need currentTimeMillis, commit time should be used only for debugging purposes,  but currently suspiciously used for replication as well")
    public static void setCommitData(IndexWriter iw, long commitCommandVersion) {
        log.debug("Calling setCommitData with IW:{} commitCommandVersion:{}", (Object)iw, (Object)commitCommandVersion);
        HashMap<String, String> commitData = new HashMap<String, String>();
        commitData.put(COMMIT_TIME_MSEC_KEY, String.valueOf(System.currentTimeMillis()));
        commitData.put(COMMIT_COMMAND_VERSION, String.valueOf(commitCommandVersion));
        iw.setLiveCommitData(commitData.entrySet());
    }

    private void setDirectoryFactory(DirectoryFactory factory) {
        this.directoryFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void merge(MergePolicy.OneMerge merge) throws IOException {
        Timer.Context context;
        String segString = merge.segString();
        long totalNumDocs = merge.totalNumDocs();
        this.runningMerges.put(segString, totalNumDocs);
        if (!this.mergeTotals) {
            try {
                super.merge(merge);
            }
            finally {
                this.runningMerges.remove(segString);
            }
            return;
        }
        long deletedDocs = 0L;
        for (SegmentCommitInfo info : merge.segments) {
            totalNumDocs -= (long)info.getDelCount();
            deletedDocs += (long)info.getDelCount();
        }
        boolean major = totalNumDocs > this.majorMergeDocs;
        int segmentsCount = merge.segments.size();
        if (major) {
            this.runningMajorMerges.incrementAndGet();
            this.runningMajorMergesDocs.addAndGet(totalNumDocs);
            this.runningMajorMergesSegments.addAndGet(segmentsCount);
            if (this.mergeDetails) {
                this.majorMergedDocs.mark(totalNumDocs);
                this.majorDeletedDocs.mark(deletedDocs);
            }
            context = this.majorMerge.time();
        } else {
            this.runningMinorMerges.incrementAndGet();
            this.runningMinorMergesDocs.addAndGet(totalNumDocs);
            this.runningMinorMergesSegments.addAndGet(segmentsCount);
            context = this.minorMerge.time();
        }
        try {
            super.merge(merge);
        }
        catch (Throwable t) {
            this.mergeErrors.inc();
            throw t;
        }
        finally {
            this.runningMerges.remove(segString);
            context.stop();
            if (major) {
                this.runningMajorMerges.decrementAndGet();
                this.runningMajorMergesDocs.addAndGet(-totalNumDocs);
                this.runningMajorMergesSegments.addAndGet(-segmentsCount);
            } else {
                this.runningMinorMerges.decrementAndGet();
                this.runningMinorMergesDocs.addAndGet(-totalNumDocs);
                this.runningMinorMergesSegments.addAndGet(-segmentsCount);
            }
        }
    }

    public Map<String, Object> getRunningMerges() {
        return Collections.unmodifiableMap(this.runningMerges);
    }

    protected void doAfterFlush() throws IOException {
        if (this.flushMeter != null) {
            this.flushMeter.mark();
        }
        super.doAfterFlush();
    }

    public void close() throws IOException {
        log.debug("Closing Writer {}", (Object)this.name);
        try {
            super.close();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            log.error("Error closing IndexWriter", t);
        }
        finally {
            this.cleanup();
        }
    }

    public void rollback() throws IOException {
        log.debug("Rollback Writer {}", (Object)this.name);
        try {
            super.rollback();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            log.error("Exception rolling back IndexWriter", t);
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws IOException {
        boolean doClose = false;
        Object object = this.CLOSE_LOCK;
        synchronized (object) {
            if (!this.isClosed) {
                doClose = true;
                this.isClosed = true;
            }
        }
        if (doClose) {
            if (this.infoStream != null) {
                IOUtils.closeQuietly((Closeable)this.infoStream);
            }
            numCloses.incrementAndGet();
            if (this.directoryFactory != null) {
                this.directoryFactory.release(this.directory);
            }
            if (this.solrMetricsContext != null) {
                this.solrMetricsContext.unregister();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                assert (false) : "SolrIndexWriter was not closed prior to finalize()";
                log.error("SolrIndexWriter was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

