/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.AssertingRandom;
import com.carrotsearch.randomizedtesting.RandomSupplier;
import com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.util.Random;

public final class Randomness {
    private final long seed;
    private final Random random;
    private final RandomSupplier supplier;
    private final SeedDecorator[] decorators;

    public Randomness(Thread owner, RandomSupplier supplier, long seed, SeedDecorator ... decorators) {
        this.seed = seed;
        this.decorators = decorators;
        this.supplier = supplier;
        Random delegate = supplier.get(Randomness.decorate(seed, decorators));
        this.random = AssertingRandom.isVerifying() ? new AssertingRandom(owner, delegate) : delegate;
    }

    public Randomness(long seed, RandomSupplier supplier, SeedDecorator ... decorators) {
        this(Thread.currentThread(), supplier, seed, decorators);
    }

    public Random getRandom() {
        return this.random;
    }

    RandomSupplier getRandomSupplier() {
        return this.supplier;
    }

    SeedDecorator[] getDecorators() {
        return this.decorators;
    }

    Randomness clone(Thread newOwner) {
        return new Randomness(newOwner, this.supplier, this.seed, this.decorators);
    }

    public String toString() {
        return "[Randomness, seed=" + SeedUtils.formatSeedChain(this) + "]";
    }

    void destroy() {
        if (this.random instanceof AssertingRandom) {
            ((AssertingRandom)this.random).destroy();
        }
    }

    long getSeed() {
        return this.seed;
    }

    private static long decorate(long seed, SeedDecorator[] decorators) {
        for (SeedDecorator decorator : decorators) {
            seed = decorator.decorate(seed);
        }
        return seed;
    }
}

