/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.AbstractTable;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ArrayTable$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ArrayTable$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ArrayTable$Row;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ArrayTable$RowMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectSpliterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Table$Cell;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class ArrayTable
extends AbstractTable
implements Serializable {
    private final ImmutableList rowList;
    private final ImmutableList columnList;
    private final ImmutableMap rowKeyToIndex;
    private final ImmutableMap columnKeyToIndex;
    private final Object[][] array;
    @MonotonicNonNullDecl
    private transient ArrayTable$RowMap rowMap;

    public Object at(int n, int n2) {
        Preconditions.checkElementIndex(n, this.rowList.size());
        Preconditions.checkElementIndex(n2, this.columnList.size());
        return this.array[n][n2];
    }

    @CanIgnoreReturnValue
    public Object set(int n, int n2, @NullableDecl Object object) {
        Preconditions.checkElementIndex(n, this.rowList.size());
        Preconditions.checkElementIndex(n2, this.columnList.size());
        Object object2 = this.array[n][n2];
        this.array[n][n2] = object;
        return object2;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsRow(@NullableDecl Object object) {
        return this.rowKeyToIndex.containsKey(object);
    }

    @Override
    public Object get(@NullableDecl Object object, @NullableDecl Object object2) {
        Integer n = (Integer)this.rowKeyToIndex.get(object);
        Integer n2 = (Integer)this.columnKeyToIndex.get(object2);
        return n == null || n2 == null ? null : this.at(n, n2);
    }

    @Override
    public boolean isEmpty() {
        return this.rowList.isEmpty() || this.columnList.isEmpty();
    }

    @Override
    @CanIgnoreReturnValue
    public Object put(Object object, Object object2, @NullableDecl Object object3) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Integer n = (Integer)this.rowKeyToIndex.get(object);
        Preconditions.checkArgument(n != null, "Row %s not in %s", object, this.rowList);
        Integer n2 = (Integer)this.columnKeyToIndex.get(object2);
        Preconditions.checkArgument(n2 != null, "Column %s not in %s", object2, this.columnList);
        return this.set(n, n2, object3);
    }

    @Override
    public int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public Set cellSet() {
        return super.cellSet();
    }

    @Override
    Iterator cellIterator() {
        return new ArrayTable$1(this, this.size());
    }

    @Override
    Spliterator cellSpliterator() {
        return CollectSpliterators.indexed(this.size(), 273, this::getCell);
    }

    private Table$Cell getCell(int n) {
        return new ArrayTable$2(this, n);
    }

    @Override
    public Map row(Object object) {
        Preconditions.checkNotNull(object);
        Integer n = (Integer)this.rowKeyToIndex.get(object);
        return n == null ? ImmutableMap.of() : new ArrayTable$Row(this, n);
    }

    @Override
    public Map rowMap() {
        ArrayTable$RowMap arrayTable$RowMap = this.rowMap;
        return arrayTable$RowMap == null ? (this.rowMap = new ArrayTable$RowMap(this, null)) : arrayTable$RowMap;
    }

    static /* synthetic */ Table$Cell access$000(ArrayTable arrayTable, int n) {
        return arrayTable.getCell(n);
    }

    static /* synthetic */ ImmutableList access$100(ArrayTable arrayTable) {
        return arrayTable.columnList;
    }

    static /* synthetic */ ImmutableList access$200(ArrayTable arrayTable) {
        return arrayTable.rowList;
    }

    static /* synthetic */ ImmutableMap access$300(ArrayTable arrayTable) {
        return arrayTable.rowKeyToIndex;
    }

    static /* synthetic */ ImmutableMap access$600(ArrayTable arrayTable) {
        return arrayTable.columnKeyToIndex;
    }
}

