/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class StringStreamToDateParseFunction
extends DateValueStream.AbstractDateValueStream {
    private final StringValueStream param;
    public static final String name = "date";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringStreamToDateParseFunction(StringValueStream param) throws SolrException {
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.param.streamStrings(value -> {
            try {
                cons.accept(Instant.parse(value).toEpochMilli());
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        });
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

