/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Conflicts;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.CounterCells;
import org.apache.cassandra.db.rows.Row;

public abstract class Cells {
    private Cells() {
    }

    public static void collectStats(Cell cell, PartitionStatisticsCollector collector) {
        collector.update(cell);
        if (cell.isCounterCell()) {
            collector.updateHasLegacyCounterShards(CounterCells.hasLegacyShards(cell));
        }
    }

    public static long reconcile(Cell existing, Cell update, DeletionTime deletion, Row.Builder builder, int nowInSec) {
        existing = existing == null || deletion.deletes(existing) ? null : existing;
        Cell cell = update = update == null || deletion.deletes(update) ? null : update;
        if (existing == null || update == null) {
            if (update != null) {
                builder.addCell(update);
            } else if (existing != null) {
                builder.addCell(existing);
            }
            return Long.MAX_VALUE;
        }
        Cell reconciled = Cells.reconcile(existing, update, nowInSec);
        builder.addCell(reconciled);
        return Math.abs(existing.timestamp() - update.timestamp());
    }

    public static Cell reconcile(Cell c1, Cell c2, int nowInSec) {
        if (c1 == null) {
            return c2 == null ? null : c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isCounterCell() || c2.isCounterCell()) {
            Conflicts.Resolution res = Conflicts.resolveCounter(c1.timestamp(), c1.isLive(nowInSec), c1.value(), c2.timestamp(), c2.isLive(nowInSec), c2.value());
            switch (res) {
                case LEFT_WINS: {
                    return c1;
                }
                case RIGHT_WINS: {
                    return c2;
                }
            }
            ByteBuffer merged = Conflicts.mergeCounterValues(c1.value(), c2.value());
            long timestamp = Math.max(c1.timestamp(), c2.timestamp());
            if (merged == c1.value() && timestamp == c1.timestamp()) {
                return c1;
            }
            if (merged == c2.value() && timestamp == c2.timestamp()) {
                return c2;
            }
            return new BufferCell(c1.column(), timestamp, 0, Integer.MAX_VALUE, merged, c1.path());
        }
        Conflicts.Resolution res = Conflicts.resolveRegular(c1.timestamp(), c1.isLive(nowInSec), c1.localDeletionTime(), c1.value(), c2.timestamp(), c2.isLive(nowInSec), c2.localDeletionTime(), c2.value());
        assert (res != Conflicts.Resolution.MERGE);
        return res == Conflicts.Resolution.LEFT_WINS ? c1 : c2;
    }

    public static long reconcileComplex(ColumnDefinition column, Iterator<Cell> existing, Iterator<Cell> update, DeletionTime deletion, Row.Builder builder, int nowInSec) {
        Comparator<CellPath> comparator = column.cellPathComparator();
        Cell nextExisting = Cells.getNext(existing);
        Cell nextUpdate = Cells.getNext(update);
        long timeDelta = Long.MAX_VALUE;
        while (nextExisting != null || nextUpdate != null) {
            int cmp;
            int n = nextExisting == null ? 1 : (cmp = nextUpdate == null ? -1 : comparator.compare(nextExisting.path(), nextUpdate.path()));
            if (cmp < 0) {
                Cells.reconcile(nextExisting, null, deletion, builder, nowInSec);
                nextExisting = Cells.getNext(existing);
                continue;
            }
            if (cmp > 0) {
                Cells.reconcile(null, nextUpdate, deletion, builder, nowInSec);
                nextUpdate = Cells.getNext(update);
                continue;
            }
            timeDelta = Math.min(timeDelta, Cells.reconcile(nextExisting, nextUpdate, deletion, builder, nowInSec));
            nextExisting = Cells.getNext(existing);
            nextUpdate = Cells.getNext(update);
        }
        return timeDelta;
    }

    public static void addNonShadowed(Cell existing, Cell update, DeletionTime deletion, Row.Builder builder, int nowInSec) {
        if (deletion.deletes(existing)) {
            return;
        }
        Cell reconciled = Cells.reconcile(existing, update, nowInSec);
        if (reconciled != update) {
            builder.addCell(existing);
        }
    }

    public static void addNonShadowedComplex(ColumnDefinition column, Iterator<Cell> existing, Iterator<Cell> update, DeletionTime deletion, Row.Builder builder, int nowInSec) {
        Comparator<CellPath> comparator = column.cellPathComparator();
        Cell nextExisting = Cells.getNext(existing);
        Cell nextUpdate = Cells.getNext(update);
        while (nextExisting != null) {
            int cmp;
            int n = cmp = nextUpdate == null ? -1 : comparator.compare(nextExisting.path(), nextUpdate.path());
            if (cmp < 0) {
                Cells.addNonShadowed(nextExisting, null, deletion, builder, nowInSec);
                nextExisting = Cells.getNext(existing);
                continue;
            }
            if (cmp == 0) {
                Cells.addNonShadowed(nextExisting, nextUpdate, deletion, builder, nowInSec);
                nextExisting = Cells.getNext(existing);
                nextUpdate = Cells.getNext(update);
                continue;
            }
            nextUpdate = Cells.getNext(update);
        }
    }

    private static Cell getNext(Iterator<Cell> iterator) {
        return iterator == null || !iterator.hasNext() ? null : iterator.next();
    }
}

