/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.CharArrayList;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.cursors.CharCursor;

public class CharStack
extends CharArrayList {
    public CharStack() {
    }

    public CharStack(int initialCapacity) {
        super(initialCapacity);
    }

    public CharStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public CharStack(CharContainer container) {
        super(container);
    }

    public void push(char e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(char e1, char e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(char e1, char e2, char e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(char e1, char e2, char e3, char e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(char[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public void push(char ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(CharContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends CharCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public char pop() {
        assert (this.elementsCount > 0);
        char v = this.buffer[--this.elementsCount];
        return v;
    }

    public char peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static CharStack newInstance() {
        return new CharStack();
    }

    public static CharStack newInstanceWithCapacity(int initialCapacity) {
        return new CharStack(initialCapacity);
    }

    public static CharStack from(char ... elements) {
        CharStack stack = new CharStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static CharStack from(CharContainer container) {
        return new CharStack(container);
    }

    @Override
    public CharStack clone() {
        return (CharStack)super.clone();
    }
}

