/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.FileCacheService;

public abstract class PoolingSegmentedFile
extends SegmentedFile {
    final FileCacheService.CacheKey cacheKey;

    protected PoolingSegmentedFile(Cleanup cleanup, ChannelProxy channel, long length) {
        this(cleanup, channel, length, length);
    }

    protected PoolingSegmentedFile(Cleanup cleanup, ChannelProxy channel, long length, long onDiskLength) {
        super(cleanup, channel, length, onDiskLength);
        this.cacheKey = cleanup.cacheKey;
    }

    public PoolingSegmentedFile(PoolingSegmentedFile copy) {
        super(copy);
        this.cacheKey = copy.cacheKey;
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = FileCacheService.instance.get(this.cacheKey);
        if (reader == null) {
            reader = this.createPooledReader();
        }
        reader.seek(position);
        return reader;
    }

    protected RandomAccessReader createPooledReader() {
        return RandomAccessReader.open(this.channel, this.length, this);
    }

    public void recycle(RandomAccessReader reader) {
        FileCacheService.instance.put(this.cacheKey, reader);
    }

    protected static class Cleanup
    extends SegmentedFile.Cleanup {
        final FileCacheService.CacheKey cacheKey = new FileCacheService.CacheKey();

        protected Cleanup(ChannelProxy channel) {
            super(channel);
        }

        @Override
        public void tidy() {
            super.tidy();
            FileCacheService.instance.invalidate(this.cacheKey, this.channel.filePath());
        }
    }
}

